/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.apache.log4j.Logger;

public class WindowsMenu
extends JMenu {
    public static Logger logger = Logger.getLogger(WindowsMenu.class);
    private static final String NO_CATEGORY = "Other windows";
    private Map<String, MenuList> categoryMap = Collections.synchronizedMap(new HashMap());
    private Map<Object, String> objectMap = Collections.synchronizedMap(new HashMap());

    public WindowsMenu(String name) {
        super(name);
        this.setEnabled(false);
    }

    void addDrawing(Drawing drawing, JRadioButtonMenuItem item) {
        String category = drawing.getWindowCategory();
        this.addCategorizedItem(category, item, drawing);
    }

    void removeDrawing(Drawing drawing) {
        this.removeItemFor(drawing);
    }

    public void addDialog(String category, final Dialog dialog) {
        JMenuItem item = new JMenuItem(dialog.getTitle());
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.toFront();
            }
        });
        this.addCategorizedItem(category, item, dialog);
    }

    public void removeDialog(Dialog dialog) {
        this.removeItemFor(dialog);
    }

    public void addFrame(String category, final Frame frame) {
        JMenuItem item = new JMenuItem(frame.getTitle());
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setExtendedState(frame.getExtendedState() & 0xFFFFFFFE);
                frame.toFront();
            }
        });
        this.addCategorizedItem(category, item, frame);
    }

    public void removeFrame(Frame frame) {
        this.removeItemFor(frame);
    }

    public void activate(Drawing drawing) {
        JRadioButtonMenuItem item = this.getItemFor(drawing);
        String element2 = null;
        for (String element2 : this.objectMap.values()) {
            if (element2 != item && element2 instanceof JRadioButtonMenuItem) {
                ((JRadioButtonMenuItem)((Object)element2)).setSelected(false);
            }
            item.setSelected(true);
        }
    }

    public void deactivate(Drawing drawing) {
        JRadioButtonMenuItem item = this.getItemFor(drawing);
        if (item != null) {
            item.setSelected(false);
        }
    }

    public void setName(Drawing drawing, String nameOnly) {
        logger.debug((Object)("WindowsMenu: changing name of drawing " + String.valueOf(drawing) + "."));
        MenuList ml = this.getMenuListFor(drawing);
        int oldPos = ml.list.indexOf(drawing);
        JRadioButtonMenuItem item = (JRadioButtonMenuItem)ml.menu.getItem(oldPos);
        ml.list.remove(oldPos);
        ml.menu.remove(oldPos);
        item.setText(nameOnly);
        int newPos = WindowsMenu.findSortedPosition(ml.menu, item);
        ml.list.insertElementAt(drawing, newPos);
        ml.menu.insert(item, newPos);
    }

    private void addCategorizedItem(String category, JMenuItem item, Object object) {
        if (this.objectMap.containsKey(object)) {
            logger.debug((Object)("WindowsMenu: object " + String.valueOf(object) + " already registered."));
            this.removeItemFor(object);
        }
        if (category == null) {
            category = NO_CATEGORY;
        }
        logger.debug((Object)("WindowsMenu: adding object " + String.valueOf(object) + " to category " + category + "."));
        MenuList ml = this.categoryMap.get(category);
        if (ml == null) {
            JMenu subMenu = new JMenu(category);
            subMenu.setFont(DrawApplication.getMenuFont());
            ml = new MenuList(subMenu, new Vector<Object>());
            this.categoryMap.put(category, ml);
            int pos = WindowsMenu.findSortedPosition(this, subMenu);
            this.insert(subMenu, pos);
            this.setEnabled(true);
        }
        int pos = WindowsMenu.findSortedPosition(ml.menu, item);
        ml.menu.insert(item, pos);
        ml.list.insertElementAt(object, pos);
        this.objectMap.put(object, category);
    }

    private JRadioButtonMenuItem getItemFor(Object object) {
        JRadioButtonMenuItem result = null;
        try {
            MenuList ml = this.getMenuListFor(object);
            int pos = ml.list.indexOf(object);
            result = (JRadioButtonMenuItem)ml.menu.getItem(pos);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    private MenuList getMenuListFor(Object object) {
        MenuList result = null;
        try {
            String category = this.objectMap.get(object);
            result = this.categoryMap.get(category);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return result;
    }

    private void removeItemFor(Object object) {
        try {
            String category = this.objectMap.get(object);
            MenuList ml = this.categoryMap.get(category);
            logger.debug((Object)("WindowsMenu: removing object " + String.valueOf(object) + " from category " + category + "."));
            int pos = ml.list.indexOf(object);
            ml.menu.remove(pos);
            ml.list.removeElementAt(pos);
            this.objectMap.remove(object);
            if (ml.list.isEmpty()) {
                this.remove(ml.menu);
                this.categoryMap.remove(category);
                if (this.categoryMap.isEmpty()) {
                    this.setEnabled(false);
                }
            }
        }
        catch (NullPointerException e) {
            logger.debug((Object)("WindowsMenu: " + String.valueOf(e) + "."));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.debug((Object)("WindowsMenu: " + String.valueOf(e) + "."));
        }
    }

    private static int findSortedPosition(JMenu menu, JMenuItem newItem) {
        int min = 0;
        int max = menu.getItemCount();
        String searchString = newItem.getText().toLowerCase();
        while (max > min) {
            int pos = (max + min) / 2;
            JMenuItem item = menu.getItem(pos);
            int comp = searchString.compareTo(item.getText().toLowerCase());
            if (comp < 0) {
                max = pos;
                continue;
            }
            if (comp < 0) continue;
            min = pos + 1;
        }
        return min;
    }

    private class MenuList {
        public final JMenu menu;
        public final Vector<Object> list;

        public MenuList(JMenu menu, Vector<Object> list) {
            this.menu = menu;
            this.list = list;
        }
    }
}

