/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class NewDrawingDialog
extends JDialog {
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton okButton;
    private JLabel typeLabel;
    private JList typeList;
    private int result = -1;

    public NewDrawingDialog(JFrame parent, String[] types, int selectedIndex) {
        super((Frame)parent, true);
        this.initComponents();
        this.typeList.setListData(types);
        if (selectedIndex < types.length && selectedIndex >= 0) {
            this.typeList.setSelectedIndex(selectedIndex);
        }
        this.pack();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.typeLabel = new JLabel();
        this.typeList = new JList();
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle("Choose new drawing type");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NewDrawingDialog.this.closeDialog();
            }
        });
        this.typeLabel.setText("Available drawing types:");
        this.getContentPane().add((Component)this.typeLabel, "North");
        this.typeList.setToolTipText("Choose the type of the drawing to create");
        this.getContentPane().add((Component)this.typeList, "Center");
        this.typeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    NewDrawingDialog.this.commitDialog();
                }
            }
        });
        this.okButton.setText("New");
        this.okButton.setToolTipText("Creates a new drawing of the chosen type.");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDrawingDialog.this.commitDialog();
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setToolTipText("Cancels the dialog without creating a drawing.");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDrawingDialog.this.closeDialog();
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
    }

    private void commitDialog() {
        this.result = this.typeList.getSelectedIndex();
        this.setVisible(false);
    }

    private void closeDialog() {
        this.result = -1;
        this.setVisible(false);
    }

    public int showDialog() {
        this.setVisible(true);
        return this.result;
    }
}

