/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingTypeManager;
import CH.ifa.draw.io.CombinationFileFilter;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.ImportHolder;
import CH.ifa.draw.io.PositionedDrawing;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.io.importFormats.ImportFormatMulti;
import de.renew.util.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class IOHelper {
    public static Logger logger = Logger.getLogger(IOHelper.class);
    private static IOHelper _instance;
    private File lastPath = new File(System.getProperty("user.dir"));
    private SimpleFileFilter lastSelectedFileFilter = DrawingTypeManager.getInstance().getDefaultFileFilter();

    private IOHelper() {
    }

    public static IOHelper getInstance() {
        if (_instance == null) {
            _instance = new IOHelper();
        }
        return _instance;
    }

    public File getLastPath() {
        return this.lastPath;
    }

    public File getSavePath(File file, SimpleFileFilter ff) {
        if (DrawPlugin.getGui() == null) {
            logger.debug((Object)"could not open save dialog: no gui!");
        }
        JFileChooser dialog = new JFileChooser();
        if (ff == null) {
            return null;
        }
        if (file == null) {
            file = DrawPlugin.getGui().drawing().getFilename();
        }
        if (file == null) {
            file = this.lastPath;
        }
        dialog.setAcceptAllFileFilterUsed(false);
        dialog.setFileFilter(ff);
        dialog.setCurrentDirectory(this.getCurrentDirectory(file));
        file = new File(StringUtil.extendFileNameBy((String)file.getPath(), (String)ff.getExtension()));
        dialog.setSelectedFile(file);
        int check = dialog.showSaveDialog(DrawPlugin.getGui().getFrame());
        if (check == 0) {
            this.lastPath = dialog.getCurrentDirectory();
            return dialog.getSelectedFile();
        }
        return null;
    }

    private Collection<SimpleFileFilter> getInputFileFilters() {
        LinkedList<SimpleFileFilter> fileFilters = new LinkedList<SimpleFileFilter>();
        Enumeration<String> enumeration = this.getDrawingTypeManager().getDrawingTypes().keys();
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement();
            fileFilters.add(this.getDrawingTypeManager().getFilter(name));
        }
        return fileFilters;
    }

    public CombinationFileFilter getFileFilter() {
        CombinationFileFilter result = new CombinationFileFilter("All known input file types");
        result.addAll(this.getInputFileFilters());
        result.setPreferedFileFilter(this.lastSelectedFileFilter);
        return result;
    }

    public CombinationFileFilter getFileFilterWithImportFormats() {
        CombinationFileFilter result = new CombinationFileFilter("All known input file types including import formats");
        result.addAll(this.getInputFileFilters());
        ImportHolder importHolder = Objects.requireNonNull(DrawPlugin.getCurrent()).getImportHolder();
        LinkedList<ImportFormat> importFormats = new LinkedList<ImportFormat>(Arrays.asList(importHolder.allImportFormats()));
        while (!importFormats.isEmpty()) {
            ImportFormat format = (ImportFormat)importFormats.remove();
            if (format instanceof ImportFormatMulti) {
                ImportFormatMulti multiFormat = (ImportFormatMulti)format;
                importFormats.addAll(Arrays.asList(multiFormat.allImportFormats()));
                continue;
            }
            FileFilter filter = format.fileFilter();
            if (!(filter instanceof SimpleFileFilter)) continue;
            result.add((SimpleFileFilter)filter);
        }
        result.setPreferedFileFilter(this.lastSelectedFileFilter);
        return result;
    }

    protected DrawingTypeManager getDrawingTypeManager() {
        return DrawingTypeManager.getInstance();
    }

    public File getSavePath(File file, SimpleFileFilter[] ff) {
        if (DrawPlugin.getGui() == null) {
            logger.debug((Object)"could not open save dialog: no gui!");
        }
        JFileChooser dialog = new JFileChooser();
        if (ff == null) {
            return null;
        }
        if (file == null) {
            file = DrawPlugin.getGui().drawing().getFilename();
        }
        if (file == null) {
            file = this.lastPath;
        }
        dialog.setAcceptAllFileFilterUsed(false);
        for (SimpleFileFilter simpleFileFilter : ff) {
            dialog.addChoosableFileFilter(simpleFileFilter);
        }
        dialog.setFileFilter(ff[0]);
        dialog.setCurrentDirectory(this.getCurrentDirectory(file));
        file = new File(StringUtil.extendFileNameBy((String)file.getPath(), (String)ff[0].getExtension()));
        dialog.setSelectedFile(file);
        int check = dialog.showSaveDialog(DrawPlugin.getGui().getFrame());
        if (check == 0) {
            this.lastPath = dialog.getCurrentDirectory();
            return DrawingFileHelper.checkAndAddExtension(dialog.getSelectedFile(), (SimpleFileFilter)dialog.getFileFilter());
        }
        return null;
    }

    public File getCurrentDirectory(File file) {
        File f;
        if (file != null && (f = file.getParentFile()) != null && f.exists()) {
            return f;
        }
        return this.lastPath;
    }

    public File[] getLoadPath(File filename, FileFilter ff, boolean multiSelection) {
        int check;
        File currentDir = this.getCurrentDirectory(filename);
        JFileChooser dialog = new JFileChooser(currentDir);
        dialog.setAcceptAllFileFilterUsed(false);
        dialog.setMultiSelectionEnabled(multiSelection);
        if (ff != null) {
            if (ff instanceof CombinationFileFilter) {
                CombinationFileFilter cff = (CombinationFileFilter)ff;
                dialog.setFileFilter(cff.getPreferedFileFilter());
                ArrayList<SimpleFileFilter> filters = new ArrayList<SimpleFileFilter>(cff.getFileFilters());
                filters.sort(Comparator.comparing(SimpleFileFilter::getExtension));
                for (SimpleFileFilter simpleFileFilter : filters) {
                    dialog.addChoosableFileFilter(simpleFileFilter);
                }
            } else {
                dialog.addChoosableFileFilter(ff);
            }
        } else {
            dialog.setAcceptAllFileFilterUsed(true);
        }
        if (filename != null) {
            dialog.setCurrentDirectory(filename);
        }
        if ((check = dialog.showOpenDialog(DrawPlugin.getGui().getFrame())) == 0) {
            this.lastPath = dialog.getCurrentDirectory();
            FileFilter simpleff = dialog.getFileFilter();
            if (simpleff instanceof SimpleFileFilter && DrawingTypeManager.getInstance().getDrawingTypes().containsValue(simpleff)) {
                this.lastSelectedFileFilter = (SimpleFileFilter)simpleff;
            }
            if (multiSelection) {
                return dialog.getSelectedFiles();
            }
            return new File[]{dialog.getSelectedFile()};
        }
        return null;
    }

    public File getLoadPath(File filename, FileFilter ff) {
        File[] files = this.getLoadPath(filename, ff, false);
        if (files == null) {
            return null;
        }
        return files[0];
    }

    public File[] getLoadPath(FileFilter filter) {
        File[] result = this.getLoadPath(null, filter, true);
        if (result == null) {
            result = new File[]{};
        }
        return result;
    }

    public File[] getLoadPath(FileFilter[] filters) {
        CombinationFileFilter filter = new CombinationFileFilter("All");
        for (FileFilter fileFilter : filters) {
            filter.add((SimpleFileFilter)fileFilter);
        }
        File[] result = this.getLoadPath(filter);
        assert (result != null) : "Failure in GuiPlugin: result == null";
        return result;
    }

    public synchronized void loadAndOpenDrawings(URL url) {
        List<PositionedDrawing> posDrawings = DrawingFileHelper.loadPositionedDrawingList(url, null);
        for (PositionedDrawing d : posDrawings) {
            DrawPlugin.getGui().openDrawing(d);
        }
    }

    public synchronized void loadAndOpenDrawings(InputStream stream, String name) throws FileNotFoundException, IOException {
        PositionedDrawing posDrawing = DrawingFileHelper.loadPositionedDrawing(stream, name);
        if (posDrawing != null) {
            try {
                DrawApplication gui = DrawPlugin.getGui();
                if (gui != null) {
                    gui.openDrawing(posDrawing);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    public synchronized void loadInViewContainer(PositionedDrawing drawing) {
        DrawApplication gui = DrawPlugin.getGui();
        if (gui != null) {
            gui.openDrawing(drawing);
        }
    }

    public synchronized void loadAndOpenDrawings(File file) {
        List<PositionedDrawing> posDrawings = DrawingFileHelper.loadPositionedDrawingList(file, null);
        for (PositionedDrawing d : posDrawings) {
            DrawPlugin.getGui().openDrawing(d);
            d.getDrawing().init();
        }
    }

    public File getSaveFile(File file, SimpleFileFilter[] filter, Drawing drawing) {
        File path;
        File result = null;
        if (file == null && (file = drawing.getFilename()) == null) {
            file = new File(this.getLastPath(), drawing.getName());
            file = DrawingFileHelper.checkAndAddExtension(file, filter[0]);
        }
        if ((path = this.getSavePath(file, filter)) != null) {
            if (path.exists()) {
                DrawApplication app = DrawPlugin.getGui();
                int answer = JOptionPane.showConfirmDialog(app.getFrame(), "The file \"" + String.valueOf(path) + "\" does already exist.\nDo you want do proceed?", "Renew: Confirm overwrite.", 0);
                if (answer == 0) {
                    result = path;
                }
            } else {
                result = path;
            }
        }
        return result;
    }

    public void setLastPath(File lp) {
        this.lastPath = lp;
    }
}

