/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.util;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.util.Geom;
import de.renew.fa.FADrawing;
import de.renew.fa.figures.EndDecoration;
import de.renew.fa.figures.FAArcConnection;
import de.renew.fa.figures.FAStateFigure;
import de.renew.fa.figures.FATextFigure;
import de.renew.fa.figures.FigureDecoration;
import de.renew.fa.figures.StartDecoration;
import de.renew.fa.figures.StartEndDecoration;
import de.renew.fa.model.Arc;
import de.renew.fa.model.FA;
import de.renew.fa.model.FAImpl;
import de.renew.fa.model.Letter;
import de.renew.fa.model.State;
import de.renew.fa.model.Word;
import de.renew.fa.model.WordImpl;
import de.renew.faformalism.util.FAAutomatonSimulationHelper;
import de.renew.faformalism.util.FASyntaxChecker;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import net.automatalib.automata.base.fast.AbstractFastState;
import net.automatalib.automata.fsa.impl.FastNFA;
import net.automatalib.automata.fsa.impl.FastNFAState;
import net.automatalib.words.Alphabet;
import org.apache.log4j.Logger;

public class FAHelper {
    private static final Logger LOGGER = Logger.getLogger(FAHelper.class);
    private static final String ACCEPTINGNAME = "accepting";
    private static final String INITIALNAME = "init";

    public static Drawing convertModelToDrawing(FA fa) {
        HashMap<State, FAStateFigure> figures = new HashMap<State, FAStateFigure>();
        FADrawing faDrawing = new FADrawing();
        Iterator<State> itStates = fa.getStates();
        int xOffset = 0;
        int yToggle = 0;
        while (itStates.hasNext()) {
            State state = itStates.next();
            FAStateFigure stateFigure = new FAStateFigure();
            FATextFigure text = new FATextFigure(0, state.getName());
            text.setParent((ParentFigure)stateFigure);
            faDrawing.add((Figure)stateFigure);
            faDrawing.add((Figure)text);
            stateFigure.setFillColor(Color.white);
            if (fa.startStates().contains(state)) {
                if (fa.endStates().contains(state)) {
                    stateFigure.setDecoration(new StartEndDecoration());
                } else {
                    stateFigure.setDecoration(new StartDecoration());
                }
            } else if (fa.endStates().contains(state)) {
                stateFigure.setDecoration(new EndDecoration());
            }
            Point loc = stateFigure.displayBox().getLocation();
            Dimension d = FAStateFigure.defaultDimension();
            int w2 = d.width / 2;
            int h2 = d.height / 2;
            stateFigure.displayBox(new Point(loc.x - w2, loc.y - h2), new Point(loc.x - w2 + d.width, loc.y - h2 + d.height));
            yToggle = 1 - yToggle;
            stateFigure.moveBy(xOffset += 100, 50 + 100 * yToggle);
            figures.put(state, stateFigure);
        }
        Iterator<Arc> itArcs = fa.getArcs();
        while (itArcs.hasNext()) {
            Arc arc = itArcs.next();
            FAArcConnection faArcConnection = new FAArcConnection(null, (LineDecoration)new ArrowTip(), "");
            faArcConnection.setAttribute("LineShape", 1);
            Word inscription = arc.getInscription();
            State startState = arc.getFrom();
            State endState = arc.getTo();
            Figure fromFigure = (Figure)figures.get(startState);
            Figure toFigure = (Figure)figures.get(endState);
            Connector fromCon = fromFigure.connectorAt(fromFigure.center());
            Connector toCon = toFigure.connectorAt(toFigure.center());
            faArcConnection.startPoint(fromFigure.center());
            faArcConnection.connectStart(fromCon);
            faArcConnection.endPoint(toFigure.center());
            faArcConnection.connectEnd(toCon);
            if (fromFigure.equals(toFigure)) {
                Point p = fromFigure.center();
                faArcConnection.insertPointAt(new Point(p.x - 50, p.y + 50), 1);
                faArcConnection.insertPointAt(new Point(p.x + 50, p.y + 50), 2);
            } else if (fa.hasArc(endState.getName(), startState.getName())) {
                Point d = FAHelper.getOrthonormalPointOffset(fromFigure, toFigure);
                faArcConnection.insertPointAt(d, 1);
            }
            FATextFigure text = new FATextFigure(1, inscription.getName());
            if (!inscription.isEmpty()) {
                text.setParent((ParentFigure)faArcConnection);
            }
            faArcConnection.updateConnection();
            faDrawing.add((Figure)faArcConnection);
            if (inscription.isEmpty()) continue;
            faDrawing.add((Figure)text);
        }
        faDrawing.setName(fa.getName());
        return faDrawing;
    }

    private static Point getOrthonormalPointOffset(Figure fromFigure, Figure toFigure) {
        Point a = fromFigure.center();
        Point b = toFigure.center();
        Point s = Geom.middle((Point)a, (Point)b);
        Point d = null;
        double distance = a.distance(b);
        double alpha = 50.0;
        double deltaX = (double)(a.x - b.x) / distance;
        double deltaY = (double)(a.y - b.y) / distance;
        d = new Point(Double.valueOf((double)s.x - alpha * deltaY).intValue(), Double.valueOf((double)s.y + alpha * deltaX).intValue());
        return d;
    }

    public static String getArcName(Word inscription, State from, State to) {
        String inscriptionText = inscription.isEmpty() ? "" : inscription.getName();
        return "(" + from.getName() + ":" + inscriptionText + ":" + to.getName() + ")";
    }

    public static FA getModel(FADrawing drawing) {
        FigureEnumeration childEnum;
        FAImpl fa = new FAImpl();
        fa.setName(drawing.getName());
        int lowestAvailableIndex = 0;
        HashMap<Object, Object> stateMap = new HashMap<Object, Object>();
        FigureEnumeration enumeration = drawing.figures();
        while (enumeration.hasMoreElements()) {
            Figure figure;
            Object object = enumeration.nextElement();
            if (!(object instanceof FAStateFigure)) continue;
            Object stateFig = (FAStateFigure)((Object)object);
            String name = null;
            childEnum = stateFig.children();
            if (childEnum.hasMoreElements() && (figure = childEnum.nextFigure()) instanceof FATextFigure) {
                FATextFigure text = (FATextFigure)figure;
                name = text.getText();
            }
            if (stateMap.get(stateFig) != null) {
                name = null;
            }
            stateMap.put(stateFig, name);
        }
        for (FAStateFigure faState : stateMap.keySet()) {
            if (stateMap.get((Object)faState) == null) {
                String name = "(" + lowestAvailableIndex + ")";
                while (fa.getStateByName(name) != null) {
                    name = "(" + ++lowestAvailableIndex + ")";
                }
                ++lowestAvailableIndex;
                stateMap.put((Object)faState, name);
            }
            State state = fa.newState((String)stateMap.get((Object)faState));
            FigureDecoration deco = faState.getDecoration();
            if (deco == null) continue;
            if (deco instanceof StartDecoration) {
                state.setStartState(true);
            }
            if (deco instanceof StartEndDecoration) {
                state.setEndState(true);
                state.setStartState(true);
            }
            if (!(deco instanceof EndDecoration)) continue;
            state.setEndState(true);
        }
        enumeration = drawing.figures();
        while (enumeration.hasMoreElements()) {
            Figure fig = (Figure)enumeration.nextElement();
            if (!(fig instanceof FAArcConnection)) continue;
            FAArcConnection arc1 = (FAArcConnection)fig;
            childEnum = arc1.children();
            Word inscription = null;
            if (childEnum.hasMoreElements()) {
                TextFigure child = (TextFigure)childEnum.nextFigure();
                String inscriptionText = child.getText();
                if (inscriptionText.length() > 0) {
                    inscription = fa.newWord(inscriptionText);
                    for (int i = 0; i < inscriptionText.length(); ++i) {
                        char character = inscriptionText.charAt(i);
                        if (character == ',') continue;
                        fa.newLetter(Character.toString(character));
                    }
                } else {
                    System.err.println("FAHelper: length of text of inscription is 0.");
                }
            } else {
                inscription = fa.newWord("");
            }
            FAArcConnection line = (FAArcConnection)fig;
            Figure startfig = line.startFigure();
            Figure endfig = line.endFigure();
            if (startfig instanceof FAStateFigure) {
                FAStateFigure start = (FAStateFigure)startfig;
                if (endfig instanceof FAStateFigure) {
                    FAStateFigure end = (FAStateFigure)endfig;
                    State from = fa.getStateByName((String)stateMap.get((Object)start));
                    State to = fa.getStateByName((String)stateMap.get((Object)end));
                    fa.newArc(from, inscription, to);
                    continue;
                }
            }
            LOGGER.warn((Object)"Ignoring Arc: not connected to state figure.");
        }
        return fa;
    }

    public static Properties toProperties(FA fa) {
        Properties properties = new Properties();
        properties.setProperty("Z", FAHelper.getStates(fa).toString());
        properties.setProperty("Sigma", FAHelper.getAlphabet(fa).toString());
        properties.setProperty("K", FAHelper.getArcs(fa).toString());
        properties.setProperty("Z_Start", fa.startStates().toString());
        properties.setProperty("Z_End", fa.endStates().toString());
        return properties;
    }

    private static Vector<State> getStates(FA fa) {
        Vector<State> v = new Vector<State>();
        Iterator<State> it = fa.getStates();
        while (it.hasNext()) {
            State state = it.next();
            v.add(state);
        }
        return v;
    }

    private static Vector<Letter> getAlphabet(FA fa) {
        Vector<Letter> v = new Vector<Letter>();
        Iterator<Letter> it = fa.getAlphabet();
        while (it.hasNext()) {
            Letter letter = it.next();
            v.add(letter);
        }
        return v;
    }

    private static Vector<Arc> getArcs(FA fa) {
        Vector<Arc> v = new Vector<Arc>();
        Iterator<Arc> it = fa.getArcs();
        while (it.hasNext()) {
            Arc arc = it.next();
            v.add(arc);
        }
        return v;
    }

    public static FastNFA<String> convertFAModelToAutomaton(FA fa, Alphabet<String> alphabet) {
        HashMap<Arc, List<String>> arcInscriptions = new HashMap<Arc, List<String>>();
        HashMap<State, List<Arc>> outGoingArcs = new HashMap<State, List<Arc>>();
        Iterator<Arc> arcIterator = fa.getArcs();
        while (arcIterator.hasNext()) {
            Arc arc = arcIterator.next();
            List list = FAAutomatonSimulationHelper.splitNFAArcInscription((String)arc.getInscription().getName());
            arcInscriptions.put(arc, list);
            State from = arc.getFrom();
            ArrayList<Arc> outArcs = (ArrayList<Arc>)outGoingArcs.get(from);
            if (outArcs == null) {
                outArcs = new ArrayList<Arc>();
            }
            outArcs.add(arc);
            outGoingArcs.put(from, outArcs);
        }
        HashMap<State, Set<State>> epsilonStates = new HashMap<State, Set<State>>();
        for (State s : fa.getStatesAsArray()) {
            epsilonStates.put(s, FAHelper.depthFirstEpsilonSearch(s, outGoingArcs, arcInscriptions));
        }
        alphabet.remove((Object)"");
        FastNFA fastNFA = new FastNFA(alphabet);
        HashMap<State, FastNFAState> stateMap = new HashMap<State, FastNFAState>();
        for (State s : fa.getStatesAsArray()) {
            boolean isAccepting = s.isEndState();
            for (State eState : (Set)epsilonStates.get(s)) {
                isAccepting = isAccepting || eState.isEndState();
            }
            stateMap.put(s, fastNFA.addState(isAccepting));
        }
        for (State s : fa.getStatesAsArray()) {
            if (!s.isStartState()) continue;
            for (State eState : (Set)epsilonStates.get(s)) {
                fastNFA.setInitial((AbstractFastState)((FastNFAState)stateMap.get(eState)), true);
            }
        }
        for (Arc arc : arcInscriptions.keySet()) {
            for (String inscr : arcInscriptions.get(arc)) {
                if (inscr.isEmpty()) continue;
                inscr = inscr.replaceAll("\\s", "");
                State from = arc.getFrom();
                Set toClosure = (Set)epsilonStates.get(arc.getTo());
                for (State to : toClosure) {
                    fastNFA.addTransition((Object)((FastNFAState)stateMap.get(from)), (Object)inscr, (Object)((FastNFAState)stateMap.get(to)));
                }
            }
        }
        return fastNFA;
    }

    private static Set<State> depthFirstEpsilonSearch(State state, HashMap<State, List<Arc>> outArcs, HashMap<Arc, List<String>> arcInscriptions) {
        HashSet<State> discovered = new HashSet<State>();
        Stack<State> stack = new Stack<State>();
        stack.push(state);
        while (!stack.isEmpty()) {
            State currentState = (State)stack.pop();
            discovered.add(currentState);
            List<Arc> arcs = outArcs.get(currentState);
            if (arcs == null) continue;
            for (Arc a : arcs) {
                if (a == null || !arcInscriptions.get(a).contains("") || discovered.contains(a.getTo())) continue;
                stack.push(a.getTo());
            }
        }
        return discovered;
    }

    public static FA regexToNfa(String regex) {
        try {
            FASyntaxChecker.checkNFAWordSyntax((String)regex);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        regex = regex.replaceAll("[+]", "|");
        regex = regex.replaceAll("\\^[|]", "+");
        regex = regex.replaceAll("\\^[*]", "*");
        return FAHelper.buildNFARecursively(regex, 0);
    }

    private static FA buildNFARecursively(String regex, int lowestAvailableIndex) {
        FAImpl result;
        block36: {
            State acceptingState;
            State initialState;
            block34: {
                State tempLeftInit;
                State intermediate;
                int openBracket;
                block37: {
                    block35: {
                        result = new FAImpl();
                        initialState = result.newState(INITIALNAME);
                        initialState.setStartState(true);
                        acceptingState = result.newState(ACCEPTINGNAME);
                        acceptingState.setEndState(true);
                        if (regex.length() == 0) {
                            result.newArc(initialState, new WordImpl(""), acceptingState);
                            return result;
                        }
                        if (regex.length() == 1) {
                            result.newArc(initialState, new WordImpl(regex), acceptingState);
                            return result;
                        }
                        ArrayList<Integer> unionIndexList = new ArrayList<Integer>();
                        openBracket = 0;
                        block9: for (int i = 0; i < regex.length(); ++i) {
                            switch (regex.charAt(i)) {
                                case '(': {
                                    ++openBracket;
                                    continue block9;
                                }
                                case ')': {
                                    --openBracket;
                                    continue block9;
                                }
                                case '|': {
                                    if (openBracket != 0) continue block9;
                                    unionIndexList.add(i);
                                }
                            }
                        }
                        if (!unionIndexList.isEmpty()) {
                            int currentWordIndex = 0;
                            ArrayList<FA> subAutomataList = new ArrayList<FA>();
                            Iterator iterator = unionIndexList.iterator();
                            while (iterator.hasNext()) {
                                int unionIndex = (Integer)iterator.next();
                                FA temp = FAHelper.buildNFARecursively(regex.substring(currentWordIndex, unionIndex), lowestAvailableIndex);
                                subAutomataList.add(temp);
                                lowestAvailableIndex += temp.numberOfStates() - 2;
                                currentWordIndex = unionIndex + 1;
                            }
                            FA temp = FAHelper.buildNFARecursively(regex.substring(currentWordIndex), lowestAvailableIndex);
                            subAutomataList.add(temp);
                            lowestAvailableIndex += temp.numberOfStates() - 2;
                            for (FA automaton : subAutomataList) {
                                State tempInit = result.newState("" + lowestAvailableIndex);
                                State tempEnd = result.newState("" + ++lowestAvailableIndex);
                                ++lowestAvailableIndex;
                                result.newArc(initialState, new WordImpl(""), tempInit);
                                result.newArc(tempEnd, new WordImpl(""), acceptingState);
                                Iterator<Arc> arcIterator = automaton.getArcs();
                                while (arcIterator.hasNext()) {
                                    FAHelper.addArc(result, arcIterator.next(), tempInit, tempEnd);
                                }
                            }
                            return result;
                        }
                        if (regex.charAt(0) != '(') break block34;
                        boolean oneBigBracket = true;
                        openBracket = 0;
                        for (int i = 0; i < regex.length(); ++i) {
                            switch (regex.charAt(i)) {
                                case '(': {
                                    ++openBracket;
                                    break;
                                }
                                case ')': {
                                    if (--openBracket != 0) break;
                                    if (i == regex.length() - 2) {
                                        oneBigBracket = regex.charAt(i + 1) == '+' || regex.charAt(i + 1) == '*';
                                        break;
                                    }
                                    if (i == regex.length() - 1) break;
                                    oneBigBracket = false;
                                }
                            }
                            if (oneBigBracket) continue;
                            openBracket = i + 1;
                            break;
                        }
                        if (!oneBigBracket) break block35;
                        if (regex.endsWith("*")) {
                            result.newArc(initialState, new WordImpl(""), acceptingState);
                            FA tempFA = FAHelper.buildNFARecursively(regex.substring(1, regex.length() - 2), lowestAvailableIndex);
                            State tempEnd = result.newState("" + (lowestAvailableIndex += tempFA.numberOfStates() - 2));
                            result.newArc(tempEnd, new WordImpl(""), initialState);
                            Iterator<Arc> arcIterator = tempFA.getArcs();
                            while (arcIterator.hasNext()) {
                                FAHelper.addArc(result, arcIterator.next(), initialState, tempEnd);
                            }
                        } else if (regex.endsWith("+")) {
                            FA tempFA = FAHelper.buildNFARecursively(regex.substring(1, regex.length() - 2), lowestAvailableIndex);
                            result.newArc(acceptingState, new WordImpl(""), initialState);
                            Iterator<Arc> arcIterator = tempFA.getArcs();
                            while (arcIterator.hasNext()) {
                                FAHelper.addArc(result, arcIterator.next(), initialState, acceptingState);
                            }
                        } else {
                            FA tempFA = FAHelper.buildNFARecursively(regex.substring(1, regex.length() - 1), lowestAvailableIndex);
                            Iterator<Arc> arcIterator = tempFA.getArcs();
                            while (arcIterator.hasNext()) {
                                FAHelper.addArc(result, arcIterator.next(), initialState, acceptingState);
                            }
                        }
                        break block36;
                    }
                    int offset = 0;
                    if (regex.charAt(openBracket) == '+' || regex.charAt(openBracket) == '*') {
                        ++offset;
                    }
                    FA leftFA = FAHelper.buildNFARecursively(regex.substring(0, openBracket + offset), lowestAvailableIndex);
                    FA rightFA = FAHelper.buildNFARecursively(regex.substring(openBracket + offset), lowestAvailableIndex += leftFA.numberOfStates() - 2);
                    intermediate = result.newState("" + (lowestAvailableIndex += rightFA.numberOfStates() - 2));
                    tempLeftInit = result.newState("" + ++lowestAvailableIndex);
                    result.newArc(initialState, new WordImpl(""), tempLeftInit);
                    Iterator<Arc> arcIterator = leftFA.getArcs();
                    while (arcIterator.hasNext()) {
                        FAHelper.addArc(result, arcIterator.next(), tempLeftInit, intermediate);
                    }
                    arcIterator = rightFA.getArcs();
                    while (arcIterator.hasNext()) {
                        FAHelper.addArc(result, arcIterator.next(), intermediate, acceptingState);
                    }
                    if (regex.charAt(openBracket) != '*') break block37;
                    result.newArc(initialState, new WordImpl(""), intermediate);
                    break block36;
                }
                if (regex.charAt(openBracket) != '+') break block36;
                result.newArc(intermediate, new WordImpl(""), tempLeftInit);
                result.newArc(initialState, new WordImpl(""), tempLeftInit);
                break block36;
            }
            if (regex.charAt(1) == '*' || regex.charAt(1) == '+') {
                State loopState = result.newState("" + lowestAvailableIndex);
                State nextState = result.newState("" + ++lowestAvailableIndex);
                FA rest = FAHelper.buildNFARecursively(regex.substring(2), ++lowestAvailableIndex);
                Iterator<Arc> arcIterator = rest.getArcs();
                while (arcIterator.hasNext()) {
                    FAHelper.addArc(result, arcIterator.next(), nextState, acceptingState);
                }
                result.newArc(initialState, new WordImpl(""), loopState);
                result.newArc(loopState, new WordImpl("" + regex.charAt(0)), loopState);
                if (regex.charAt(1) == '*') {
                    result.newArc(loopState, new WordImpl(""), nextState);
                } else {
                    result.newArc(loopState, new WordImpl("" + regex.charAt(0)), nextState);
                }
            } else {
                State nextState = result.newState("" + lowestAvailableIndex);
                result.newArc(initialState, new WordImpl("" + regex.charAt(0)), nextState);
                FA rest = FAHelper.buildNFARecursively(regex.substring(1), ++lowestAvailableIndex);
                Iterator<Arc> arcIterator = rest.getArcs();
                while (arcIterator.hasNext()) {
                    FAHelper.addArc(result, arcIterator.next(), nextState, acceptingState);
                }
            }
        }
        return result;
    }

    private static void addArc(FA result, Arc arc, State tempInit, State tempEnd) {
        String fromName = arc.getFrom().getName();
        String toName = arc.getTo().getName();
        if (fromName.equals(INITIALNAME) && toName.equals(INITIALNAME)) {
            result.newArc(tempInit, arc.getInscription(), tempInit);
        } else if (fromName.equals(ACCEPTINGNAME) && toName.equals(ACCEPTINGNAME)) {
            result.newArc(tempEnd, arc.getInscription(), tempEnd);
        } else if (fromName.equals(INITIALNAME) && toName.equals(ACCEPTINGNAME)) {
            result.newArc(tempInit, arc.getInscription(), tempEnd);
        } else if (fromName.equals(ACCEPTINGNAME) && toName.equals(INITIALNAME)) {
            result.newArc(tempEnd, arc.getInscription(), tempInit);
        } else if (fromName.equals(INITIALNAME)) {
            State to = result.getStateByName(toName);
            if (to == null) {
                to = result.newState(toName);
            }
            result.newArc(tempInit, arc.getInscription(), to);
        } else if (toName.equals(ACCEPTINGNAME)) {
            State from = result.getStateByName(fromName);
            if (from == null) {
                from = result.newState(fromName);
            }
            result.newArc(from, arc.getInscription(), tempEnd);
        } else if (toName.equals(INITIALNAME)) {
            State from = result.getStateByName(fromName);
            if (from == null) {
                from = result.newState(fromName);
            }
            result.newArc(from, arc.getInscription(), tempInit);
        } else if (fromName.equals(ACCEPTINGNAME)) {
            State to = result.getStateByName(toName);
            if (to == null) {
                to = result.newState(fromName);
            }
            result.newArc(tempEnd, arc.getInscription(), to);
        } else {
            State to;
            State from = result.getStateByName(fromName);
            if (from == null) {
                from = result.newState(fromName);
            }
            if ((to = result.getStateByName(toName)) == null) {
                to = result.newState(toName);
            }
            result.newArc(from, arc.getInscription(), to);
        }
    }
}

