/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.figures;

import CH.ifa.draw.framework.ParentFigure;
import de.renew.fa.FAPlugin;
import de.renew.fa.figures.FAArcConnection;
import de.renew.fa.figures.FAStateFigure;
import de.renew.gui.CPNTextFigure;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import org.apache.log4j.Logger;

public class FATextFigure
extends CPNTextFigure {
    static final long serialVersionUID = -7270464173137023567L;
    private static final Logger LOGGER = Logger.getLogger(FATextFigure.class);
    public static final FATextFigure NAME = new FATextFigure(2);
    public static final FATextFigure INSCRIPTION = new FATextFigure(1);

    public FATextFigure() {
        this(1, true);
    }

    public FATextFigure(int type) {
        this(type, true);
        LOGGER.debug((Object)("FATextFigure of type " + this.fType + " created"));
    }

    public FATextFigure(int type, boolean canBeConnected) {
        super(type, canBeConnected);
    }

    public FATextFigure(int type, String text) {
        this(type, true);
        this.setText(text);
    }

    protected void drawLine(Graphics g, int i) {
        Font font = this.getLineFont(i);
        g.setFont(font);
        boolean useIndices = FAPlugin.getCurrent().getUseIndices();
        int x = this.getLineBox((Graphics)g, (int)i).x;
        int y = this.getLineBox((Graphics)g, (int)i).y;
        String text = this.getLine(i);
        if (!useIndices || text == null || text.equals("")) {
            g.drawString(text, x, y + FATextFigure.getMetrics((Font)font, (Graphics)g).getAscent());
        } else {
            AttributedString aStr = this.getFAText(text);
            Graphics2D g2d = (Graphics2D)g;
            g2d.drawString(aStr.getIterator(), x, y + FATextFigure.getMetrics((Font)font, (Graphics)g).getAscent());
        }
    }

    private AttributedString getFAText(String text) {
        String strippedtext = text.replaceAll("_\\{(.*?)\\}", "$1");
        strippedtext = strippedtext.replaceFirst("_", "");
        AttributedString aStr = new AttributedString(strippedtext);
        if (!"".equals(text)) {
            aStr.addAttribute(TextAttribute.SIZE, (Integer)this.getAttribute("FontSize") + 2);
            if (this.getType() == 2) {
                aStr.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, 0, strippedtext.length());
            }
        }
        if (!text.contains("_")) {
            return aStr;
        }
        if (!text.contains("{")) {
            int index = text.indexOf(95);
            aStr.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB, index, strippedtext.length());
            return aStr;
        }
        boolean indexswitch = false;
        boolean bracketswitch = false;
        int pos = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '_') {
                indexswitch = true;
                continue;
            }
            if (indexswitch) {
                if (c == '}') {
                    bracketswitch = false;
                    indexswitch = false;
                    continue;
                }
                if (c == '{') {
                    bracketswitch = true;
                    continue;
                }
            }
            if (indexswitch && bracketswitch) {
                aStr.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB, pos + 0, pos + 1);
            }
            ++pos;
        }
        return aStr;
    }

    public Dimension getLineDimension(int i, Graphics g) {
        FAPlugin plugin = FAPlugin.getCurrent();
        boolean useIndices = false;
        if (plugin != null) {
            useIndices = plugin.getUseIndices();
        }
        if (!useIndices) {
            return super.getLineDimension(i, g);
        }
        FontMetrics metrics = FATextFigure.getMetrics((Font)this.getLineFont(i), (Graphics)g);
        AttributedString faText = this.getFAText(this.getLine(i));
        AttributedCharacterIterator it = faText.getIterator();
        Rectangle2D stringBounds = metrics.getStringBounds(it, it.getBeginIndex(), it.getEndIndex(), g);
        double width = 0.0;
        double heightaddition = 0.0;
        it.first();
        for (int idx = 0; idx < it.getEndIndex(); ++idx) {
            char c = it.current();
            if (c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9') {
                width += (double)metrics.charWidth(c) / 1.5;
                heightaddition = metrics.getHeight() / 3;
            } else {
                width += (double)metrics.charWidth(c);
            }
            it.next();
        }
        return new Dimension((int)width, (int)stringBounds.getBounds().getHeight() + (int)heightaddition);
    }

    protected boolean canBeParent(int type, ParentFigure parent) {
        switch (type) {
            case 0: {
                return true;
            }
            case 1: {
                return parent instanceof FAArcConnection;
            }
            case 2: 
            case 3: {
                return parent instanceof FAArcConnection || parent instanceof FAStateFigure;
            }
        }
        return false;
    }

    public String getName() {
        String cln = ((Object)((Object)this)).getClass().getName();
        int ind = cln.lastIndexOf(46) + 1;
        if (ind > 0) {
            cln = cln.substring(ind);
        }
        return cln + "(" + this.getText() + ")";
    }

    public String toString() {
        return this.getText();
    }
}

