/*
 * Decompiled with CFR 0.152.
 */
package de.renew.windowmanagement;

import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.gui.DockFrontend;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CPreferenceModel;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.CWorkingArea;
import bibliothek.gui.dock.common.DefaultMultipleCDockable;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.MultipleCDockableLayout;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.event.CControlListener;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.event.CKeyboardListener;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import bibliothek.gui.dock.common.grouping.DockableGrouping;
import bibliothek.gui.dock.common.grouping.PlaceholderGrouping;
import bibliothek.gui.dock.common.intern.CDockFrontend;
import bibliothek.gui.dock.common.menu.CLayoutChoiceMenuPiece;
import bibliothek.gui.dock.common.menu.CLookAndFeelMenuPiece;
import bibliothek.gui.dock.common.menu.CPreferenceMenuPiece;
import bibliothek.gui.dock.common.menu.SingleCDockableListMenuPiece;
import bibliothek.gui.dock.common.perspective.CDockablePerspective;
import bibliothek.gui.dock.common.perspective.CGridPerspective;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.facile.lookandfeel.DockableCollector;
import bibliothek.gui.dock.facile.menu.RootMenuPiece;
import bibliothek.gui.dock.support.lookandfeel.ComponentCollector;
import bibliothek.gui.dock.support.lookandfeel.LookAndFeelList;
import bibliothek.gui.dock.support.menu.MenuPiece;
import bibliothek.gui.dock.support.menu.SeparatingMenuPiece;
import bibliothek.util.Path;
import de.renew.plugin.PluginManager;
import de.renew.windowmanagement.HotDrawFocusManager;
import de.renew.windowmanagement.RenewMenuBar;
import de.renew.windowmanagement.RenewShutdownHook;
import de.renew.windowmanagement.UnknownMenuSectionException;
import de.renew.windowmanagement.Workbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class WorkbenchImpl
implements Workbench {
    private JFrame _mainframe;
    private CControl _controller;
    private RenewMenuBar _fMenu;
    private JTextField _fStatusLine;
    private JPanel _fStaticPanel;
    public static final Path LOWER_LEFT_GROUP = new Path(new String[]{"drawinglayout", "lowerleft"});
    public static final Path UPPER_LEFT_GROUP = new Path(new String[]{"drawinglayout", "upperleft"});
    public static final Path UPPER_RIGHT_GROUP = new Path(new String[]{"drawinglayout", "upperright"});
    public static final Path LOWER_RIGHT_GROUP = new Path(new String[]{"drawinglayout", "lowerright"});
    public static final Logger LOGGER = Logger.getLogger(WorkbenchImpl.class);
    private static final int FMAX_CONSOLE_LINES = 80;
    private CWorkingArea _fDrawingsArea;

    public WorkbenchImpl(RenewMenuBar menuBar, JFrame frame) {
        UIManager.installLookAndFeel("Darcula", "com.bulenkov.darcula.DarculaLaf");
        LOGGER.debug((Object)"Starting Workbench.");
        this._fMenu = menuBar;
        this._fStaticPanel = new JPanel();
        this._fStaticPanel.setLayout(new BoxLayout(this._fStaticPanel, 3));
        this._fStaticPanel.setBackground(Color.lightGray);
        this._mainframe = frame;
        this._mainframe.setTitle("RENEW - the Reference Net Workshop");
        this._mainframe.setLayout(new BorderLayout());
        this._mainframe.setMinimumSize(new Dimension(800, 600));
        this._mainframe.setPreferredSize(new Dimension(1000, 680));
        this._controller = new CControl(this._mainframe);
        this._mainframe.add((Component)this._controller.getContentArea());
        this._controller.putProperty(CControl.KEY_MAXIMIZE_CHANGE, null);
        this._controller.putProperty(CControl.KEY_GOTO_MAXIMIZED, null);
        this._controller.putProperty(CControl.KEY_GOTO_MINIMIZED, null);
        this._controller.putProperty(CControl.KEY_CANCEL_OPERATION, null);
        this._controller.putProperty(CControl.KEY_CLOSE, null);
        this._controller.putProperty(CControl.KEY_GOTO_EXTERNALIZED, null);
        this._controller.putProperty(CControl.KEY_GOTO_NORMALIZED, null);
        this._mainframe.getContentPane().add((Component)this._fStaticPanel, "North");
        this._mainframe.setJMenuBar(this._fMenu);
        new HotDrawFocusManager(this._fMenu);
        CPreferenceModel preferences = new CPreferenceModel(this._controller);
        this._controller.setPreferenceModel((PreferenceModel)preferences);
        RootMenuPiece system = new RootMenuPiece("System", false, new MenuPiece[0]);
        system.add((MenuPiece)new SeparatingMenuPiece((MenuPiece)new CLookAndFeelMenuPiece(this._controller), false, false, true));
        RootMenuPiece layout = new RootMenuPiece("Layout", false, new MenuPiece[0]);
        layout.add((MenuPiece)new CLayoutChoiceMenuPiece(this._controller, true));
        system.add((MenuPiece)new SeparatingMenuPiece((MenuPiece)layout, false, false, true));
        system.add((MenuPiece)new CPreferenceMenuPiece(this._controller));
        RootMenuPiece windows = new RootMenuPiece("Windows", false, new MenuPiece[0]);
        windows.add((MenuPiece)new SingleCDockableListMenuPiece(this._controller));
        try {
            this._fMenu.addMenu(windows.getMenu(), 5);
            this._fMenu.addMenu(system.getMenu(), 5);
        }
        catch (UnknownMenuSectionException e) {
            e.printStackTrace();
        }
        this._mainframe.getContentPane().add((Component)this._controller.getContentArea(), "Center");
        this._fDrawingsArea = this._controller.createWorkingArea("drawing area");
        this.initializeControl(this._controller);
        this._fStatusLine = new JTextField(40);
        this._fStatusLine.setEditable(false);
        this._mainframe.add((Component)this._fStatusLine, "South");
        this.showStatus("Welcome to Renew - the Reference Net Workshop");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this._mainframe.setSize(screenSize.width, screenSize.height);
        this._mainframe.pack();
        this._mainframe.setVisible(true);
        DockableCollector collector = new DockableCollector((DockFrontend)this._controller.intern());
        LookAndFeelList.getDefaultList().addComponentCollector((ComponentCollector)collector);
        CDockFrontend frontend = this._controller.intern();
        File file = new File(PluginManager.getPreferencesLocation(), "renewLayoutSettings");
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                frontend.read(dataInputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WorkbenchImpl.this._controller.setTheme("flat");
            }
        });
    }

    private void initializeControl(CControl control) {
        LOGGER.debug((Object)"Initializing base perspective.");
        CPerspective perspective = control.getPerspectives().createEmptyPerspective();
        CGridPerspective center = perspective.getContentArea().getCenter();
        center.gridPlaceholder(0.0, 0.0, 20.0, 10.0, new Path[]{UPPER_LEFT_GROUP});
        center.gridPlaceholder(0.0, 10.0, 20.0, 20.0, new Path[]{LOWER_LEFT_GROUP});
        center.gridAdd(20.0, 0.0, 50.0, 30.0, new CDockablePerspective[]{(CDockablePerspective)perspective.getStation("drawing area")});
        center.gridPlaceholder(70.0, 0.0, 20.0, 10.0, new Path[]{UPPER_RIGHT_GROUP});
        center.gridPlaceholder(70.0, 10.0, 20.0, 20.0, new Path[]{LOWER_RIGHT_GROUP});
        control.getPerspectives().setPerspective("basePerspective", perspective, true);
        control.load("basePerspective");
    }

    @Override
    public JFrame getMainFrame() {
        return this._mainframe;
    }

    @Override
    public void showStatus(final String string) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                WorkbenchImpl.this._fStatusLine.setText(string);
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    @Override
    public void addStaticPanel(JPanel panel) {
        this._fStaticPanel.add(panel);
        this._mainframe.pack();
    }

    @Override
    public void addEditorWindow(final MultipleCDockableLayout layout, final String factoryID) {
        LOGGER.debug((Object)("Adding new Editor window for layout " + layout.toString()));
        LOGGER.debug((Object)("Using factoryID " + factoryID));
        Runnable r = new Runnable(){

            @Override
            public void run() {
                MultipleCDockableFactory factory = WorkbenchImpl.this._controller.getMultipleDockableFactory(factoryID);
                MultipleCDockable editor = factory.read(layout);
                WorkbenchImpl.this._controller.addDockable(editor);
                editor.setWorkingArea((CStation)WorkbenchImpl.this._fDrawingsArea);
                if (editor instanceof DefaultMultipleCDockable) {
                    ((DefaultMultipleCDockable)editor).setTitleShown(true);
                }
                editor.setVisible(true);
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    @Override
    public void newEditorWindow(String factoryID) {
        LOGGER.debug((Object)("Attempting to create new empty editor template for factoryID " + factoryID));
        MultipleCDockableFactory factory = this._controller.getMultipleDockableFactory(factoryID);
        this.addEditorWindow(factory.create(), factoryID);
    }

    @Override
    public void registerControlListener(CControlListener listener) {
        LOGGER.debug((Object)("Add control listener " + listener.toString()));
        this._controller.addControlListener(listener);
    }

    @Override
    public synchronized void registerEditorFactory(MultipleCDockableFactory factory, String id) {
        LOGGER.debug((Object)("Registering new editor factory under id " + id));
        if (this._controller.getMultipleDockableFactory(id) != null) {
            return;
        }
        this._controller.addMultipleDockableFactory(id, factory);
    }

    @Override
    public void registerMenu(JMenu menu) {
        this._fMenu.add(menu);
        this._mainframe.pack();
    }

    @Override
    public void registerMenu(JMenu menu, int index) throws UnknownMenuSectionException {
        this._fMenu.addMenu(menu, index);
        this._mainframe.pack();
    }

    @Override
    public void removeMenu(JMenu menu) {
        this._fMenu.remove(menu);
        this._mainframe.pack();
    }

    @Override
    public void close(MultipleCDockable dockable) {
        dockable.setVisible(false);
        if (!dockable.isVisible()) {
            this._controller.removeDockable(dockable);
        }
    }

    @Override
    public void close(SingleCDockable dockable) {
        dockable.setVisible(false);
        if (!dockable.isVisible()) {
            this._controller.removeDockable(dockable);
        }
    }

    @Override
    public void addViewWindow(final DefaultSingleCDockable dockable, final Path path) {
        LOGGER.debug((Object)("Add new view " + dockable.getTitleText()));
        LOGGER.debug((Object)("At position " + path.toString()));
        Runnable r = new Runnable(){

            @Override
            public void run() {
                dockable.setGrouping((DockableGrouping)new PlaceholderGrouping(WorkbenchImpl.this._controller, path));
                WorkbenchImpl.this._controller.addDockable((SingleCDockable)dockable);
                dockable.setVisible(true);
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void destroy() {
        LOGGER.debug((Object)"Saving current layout to disk.");
        CDockFrontend frontend = this._controller.intern();
        File file = new File(PluginManager.getPreferencesLocation(), "renewLayoutSettings");
        try {
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            frontend.write(dataOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this._mainframe.setVisible(false);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LOGGER.debug((Object)"Destroying controller and mainframe.");
                WorkbenchImpl.this._controller.destroy();
                WorkbenchImpl.this._mainframe.dispose();
            }
        });
    }

    @Override
    public void registerShutdownHook(RenewShutdownHook hook) {
    }

    @Override
    public void openGui() {
        this._mainframe.setVisible(true);
    }

    @Override
    public void registerFocusListener(CFocusListener listener) {
        this._controller.addFocusListener(listener);
    }

    @Override
    public void registerVetoClosingListener(CVetoClosingListener listener) {
        this._controller.addVetoClosingListener(listener);
    }

    @Override
    public void registerKeyboardListener(CKeyboardListener listener) {
        this._controller.addKeyboardListener(listener);
    }
}

