/*
 * Decompiled with CFR 0.152.
 */
package de.renew.windowmanagement;

import bibliothek.gui.dock.support.lookandfeel.ComponentCollector;
import bibliothek.gui.dock.support.lookandfeel.LookAndFeelList;
import de.renew.windowmanagement.UnknownMenuSectionException;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class RenewMenuBar
extends JMenuBar {
    public static final int FILE_MENU_SECTION = 0;
    public static final int DIAGRAM_MANIPULATION_SECTION = 1;
    public static final int PETRI_NET_SECTION = 2;
    public static final int ADDITIONAL_TOOLS_SECTION = 3;
    public static final int MISC_SECTION = 4;
    public static final int SYSTEMS_SECTION = 5;
    public static final int HELP_MENU_SECTION = 6;
    private static final int NUMBER_OF_SECTIONS = 7;
    private int[] _sectionHeads = new int[7];

    public RenewMenuBar() {
        final HashSet<RenewMenuBar> thisInACollection = new HashSet<RenewMenuBar>();
        thisInACollection.add(this);
        LookAndFeelList.getDefaultList().addComponentCollector(new ComponentCollector(){

            public Collection<Component> listComponents() {
                return thisInACollection;
            }
        });
    }

    public JMenu addMenu(JMenu menu, int section) throws UnknownMenuSectionException {
        if (section >= 7) {
            throw new UnknownMenuSectionException("Section id was out of bounds, please refer to the menu manager for available sections.");
        }
        if (section == 6) {
            super.add((Component)menu, this._sectionHeads[section]);
        } else {
            super.add((Component)menu, this._sectionHeads[section + 1]);
        }
        ++section;
        while (section < 7) {
            int n = section++;
            this._sectionHeads[n] = this._sectionHeads[n] + 1;
        }
        menu.setVisible(true);
        return menu;
    }

    @Override
    public Component add(Component c, int section) {
        return c;
    }

    @Override
    public JMenu add(JMenu menu) {
        try {
            this.addMenu(menu, 4);
        }
        catch (UnknownMenuSectionException unknownMenuSectionException) {
            // empty catch block
        }
        return menu;
    }

    @Override
    public void remove(Component menu) {
        int index = this.getComponentIndex(menu);
        super.remove(menu);
        for (int i = 0; i < 7; ++i) {
            if (this._sectionHeads[i] <= index) continue;
            int n = i;
            this._sectionHeads[n] = this._sectionHeads[n] - 1;
        }
    }

    public static int getNumberOfSections() {
        return 7;
    }
}

