/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.SchedulerPair;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Scheduler
implements Runnable {
    private static Logger logger = Logger.getLogger(Scheduler.class);
    private static Scheduler instance;
    private Thread schedulerThread = null;
    private TreeMap<Long, SchedulerPair> queues = new TreeMap();

    private Scheduler() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(this) + ": created instance."));
        }
    }

    public static synchronized Scheduler instance() {
        if (instance == null) {
            instance = new Scheduler();
        }
        return instance;
    }

    private void ensureRunningThread() {
        if (this.schedulerThread == null) {
            this.schedulerThread = new Thread((Runnable)this, "Renew Scheduler");
            this.schedulerThread.start();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(String.valueOf(this) + ": created thread."));
            }
        }
    }

    private SchedulerPair takeEarliest() {
        if (this.queues.isEmpty()) {
            return null;
        }
        Long key = this.queues.firstKey();
        return this.queues.remove(key);
    }

    private SchedulerPair takePairAt(long timeMillis) {
        Long key = timeMillis;
        SchedulerPair result = this.queues.remove(key);
        return result == null ? new SchedulerPair(key) : result;
    }

    private void putPair(SchedulerPair pair) {
        if (!pair.list.isEmpty()) {
            this.queues.put(pair.key, pair);
        }
    }

    public synchronized void executeIn(Runnable runnable, long deltaMillis) {
        this.executeAt(runnable, System.currentTimeMillis() + deltaMillis);
    }

    public synchronized void executeAt(Runnable runnable, long timeMillis) {
        SchedulerPair pair = this.takePairAt(timeMillis);
        pair.list.addFirst(runnable);
        this.putPair(pair);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(String.valueOf(this) + ": scheduled " + String.valueOf(runnable) + " for " + timeMillis));
        }
        this.ensureRunningThread();
        this.notifyAll();
    }

    public synchronized void cancel(Runnable runnable) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(String.valueOf(this) + ": request to cancel " + String.valueOf(runnable)));
        }
        Iterator<SchedulerPair> allElements = this.queues.values().iterator();
        Vector<Long> toRemove = new Vector<Long>(this.queues.size());
        while (allElements.hasNext()) {
            SchedulerPair pair = allElements.next();
            pair.list.remove(runnable);
            if (!pair.list.isEmpty()) continue;
            toRemove.add(pair.key);
        }
        Enumeration removeElements = toRemove.elements();
        while (removeElements.hasMoreElements()) {
            this.queues.remove(removeElements.nextElement());
        }
        this.notifyAll();
    }

    @Override
    public synchronized void run() {
        SchedulerPair pair;
        do {
            long now;
            if ((pair = this.takeEarliest()) == null) continue;
            long timeMillis = pair.key;
            if (timeMillis > (now = System.currentTimeMillis())) {
                this.putPair(pair);
                try {
                    this.wait(timeMillis - now);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            while (!pair.list.isEmpty()) {
                Runnable runnable = pair.list.removeLast();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(String.valueOf(this) + ": executing at " + now + ": " + String.valueOf(runnable)));
                }
                runnable.run();
            }
        } while (pair != null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(this) + ": quitting thread."));
        }
        this.schedulerThread = null;
    }
}

