/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HashedRelation<K, V>
implements Serializable {
    private Map<K, Set<V>> map = new HashMap<K, Set<V>>();

    public synchronized void put(K key, V elem) {
        Set<Object> set;
        if (this.map.containsKey(key)) {
            set = this.map.get(key);
        } else {
            set = new HashSet();
            this.map.put(key, set);
        }
        set.add(elem);
    }

    public synchronized void remove(K key, V elem) {
        Set<V> set = this.map.get(key);
        set.remove(elem);
        if (set.isEmpty()) {
            this.map.remove(key);
        }
    }

    public synchronized Set<K> keys() {
        return this.map.keySet();
    }

    public synchronized Set<V> elementsAt(K key) {
        if (this.map.containsKey(key)) {
            Set<V> set = this.map.get(key);
            return set;
        }
        return Collections.emptySet();
    }

    public synchronized int sizeAt(Object key) {
        if (this.map.containsKey(key)) {
            Set<V> set = this.map.get(key);
            return set.size();
        }
        return 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("de.renew.util.HashedRelation( ");
        for (K key : this.map.keySet()) {
            buffer.append(key);
            buffer.append(" -> (");
            boolean first = true;
            for (V value : this.map.get(key)) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(value);
            }
            buffer.append(") ");
        }
        buffer.append(")");
        return buffer.toString();
    }
}

