/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.models;

import de.renew.util.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class SearchFilter {
    private final String _name;
    private final Type _type;
    private final List<String> _terms;
    private final boolean _caseSensitive;

    public SearchFilter(String name, Type type, boolean caseSensitive, String ... terms) {
        this._name = name;
        this._type = type;
        this._caseSensitive = caseSensitive;
        this._terms = new ArrayList<String>();
        if (terms != null) {
            for (String text : terms) {
                String tmp = StringUtil.trimToNull((String)text);
                if (tmp == null) continue;
                this._terms.add(tmp);
            }
        }
    }

    public boolean match(String check) {
        if (this._terms.isEmpty()) {
            return true;
        }
        String toCheck = StringUtil.trimToNull((String)check);
        if (toCheck == null) {
            return true;
        }
        String checkText = this.formatCheckText(toCheck);
        Iterator<String> iterator = this._terms.iterator();
        if (iterator.hasNext()) {
            String term = iterator.next();
            return this.doesTermMatchCondition(term, checkText);
        }
        return false;
    }

    private String formatCheckText(String toCheck) {
        return this._caseSensitive ? toCheck : toCheck.toLowerCase();
    }

    private boolean doesTermMatchCondition(String term, String checkText) {
        String termText = this.formatCheckText(term);
        if (this.isStartsWith() && checkText.startsWith(termText)) {
            return true;
        }
        if (this.isContains() && checkText.contains(termText)) {
            return true;
        }
        return this.isEndsWith() && checkText.endsWith(termText);
    }

    public boolean isValid() {
        for (String text : this._terms) {
            if (text == null || text.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean isEndsWith() {
        return this._type == Type.ENDS_WITH;
    }

    private boolean isStartsWith() {
        return this._type == Type.STARTS_WITH;
    }

    private boolean isContains() {
        return this._type == Type.CONTAINS;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public Type getType() {
        return this._type;
    }

    public List<String> getTerms() {
        return this._terms;
    }

    public String getName() {
        return this._name;
    }

    public static enum Type {
        STARTS_WITH,
        CONTAINS,
        ENDS_WITH;

    }
}

