/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui;

import de.renew.navigator.events.DirectoryOpeningEvent;
import de.renew.navigator.gui.FileTreeNode;
import de.renew.navigator.models.Directory;
import de.renew.navigator.models.NavigatorFileTree;
import de.renew.navigator.models.TreeElement;
import javax.swing.event.TreeExpansionEvent;

class TreeExpansionListener
implements javax.swing.event.TreeExpansionListener {
    private static boolean _active = true;
    private final NavigatorFileTree _model;

    TreeExpansionListener(NavigatorFileTree navigatorFileTree) {
        this._model = navigatorFileTree;
    }

    public static void setActive(boolean setActivated) {
        _active = setActivated;
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        if (!_active) {
            return;
        }
        FileTreeNode node = this.extractFileTreeNode(event);
        this.extractDirectory(node).setOpened(false);
        this._model.notifyObservers(new DirectoryOpeningEvent(false, node));
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        if (!_active) {
            return;
        }
        FileTreeNode node = this.extractFileTreeNode(event);
        this.extractDirectory(node).setOpened(true);
        this._model.notifyObservers(new DirectoryOpeningEvent(true, node));
    }

    private FileTreeNode extractFileTreeNode(TreeExpansionEvent event) {
        Object lastPathComponent = event.getPath().getLastPathComponent();
        if (!(lastPathComponent instanceof FileTreeNode)) {
            throw new IllegalArgumentException("Last path component has to be a FileTreeNode");
        }
        return (FileTreeNode)lastPathComponent;
    }

    private Directory extractDirectory(FileTreeNode node) {
        TreeElement treeElement = node.getModel();
        if (treeElement instanceof Directory) {
            return (Directory)treeElement;
        }
        return (Directory)treeElement.getParent();
    }
}

