/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui;

import de.renew.navigator.models.Directory;
import de.renew.navigator.models.TreeElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FileTreeNode
implements MutableTreeNode {
    private final Vector<TreeNode> _children;
    private final TreeElement _model;
    private TreeNode _parent = null;

    public FileTreeNode(TreeElement treeElement) {
        assert (treeElement != null);
        this._children = new Vector();
        this._model = treeElement;
    }

    public Enumeration<TreeNode> children() {
        return this._children.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return this._model instanceof Directory;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this._children.elementAt(childIndex);
    }

    @Override
    public int getChildCount() {
        return this._children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this._children.indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return this._parent;
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        child.setParent(this);
        this._children.add(index, child);
    }

    public void add(MutableTreeNode child) {
        child.setParent(this);
        this._children.add(child);
    }

    @Override
    public void remove(int index) {
        this._children.remove(index);
    }

    @Override
    public void remove(MutableTreeNode node) {
        this._children.remove(node);
    }

    @Override
    public void removeFromParent() {
        if (this._parent != null && this._parent instanceof MutableTreeNode) {
            ((MutableTreeNode)this._parent).remove(this);
        }
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this._parent = newParent;
    }

    @Override
    public void setUserObject(Object object) {
    }

    public TreePath getPath() {
        LinkedList<FileTreeNode> path = new LinkedList<FileTreeNode>();
        for (TreeNode node = this; node != null; node = node.getParent()) {
            path.addFirst((FileTreeNode)node);
        }
        return new TreePath(path.toArray(new TreeNode[0]));
    }

    @Override
    public boolean isLeaf() {
        return !this.getAllowsChildren() || this._children.isEmpty();
    }

    public File getFile() {
        return this._model.getFile();
    }

    public String toString() {
        return this._model.getName();
    }

    public List<FileTreeNode> getOpenedDirectories() {
        TreeElement treeElement = this._model;
        if (!(treeElement instanceof Directory)) {
            return Collections.emptyList();
        }
        Directory directory = (Directory)treeElement;
        if (!directory.isOpened()) {
            return Collections.emptyList();
        }
        ArrayList<FileTreeNode> result = new ArrayList<FileTreeNode>();
        for (TreeNode child : this._children) {
            if (!(child instanceof FileTreeNode)) continue;
            result.addAll(((FileTreeNode)child).getOpenedDirectories());
        }
        result.add(this);
        return result;
    }

    public TreeElement getModel() {
        return this._model;
    }

    public String getToolTip() {
        return this._model.getFile().getAbsolutePath();
    }

    public Vector<TreeNode> getChildren() {
        return this._children;
    }

    public TreeNode getParentNode() {
        return this._parent;
    }
}

