/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator;

import de.renew.navigator.NavigatorController;
import de.renew.navigator.NavigatorPlugin;
import de.renew.navigator.io.FileFilterBuilder;
import de.renew.navigator.io.FilesystemIOLoader;
import de.renew.navigator.io.IOLoader;
import de.renew.navigator.io.ProgressListener;
import de.renew.navigator.models.BackgroundTask;
import de.renew.navigator.models.TreeElement;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.util.PathEntry;
import de.renew.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class FilesystemController
extends NavigatorController {
    public static final Logger LOGGER = Logger.getLogger(FilesystemController.class);
    public static final String NAVIGATOR_PREFIX = "de.renew.navigator";
    public static final String FILES_AT_STARTUP = "de.renew.navigator.filesAtStartup";
    public static final String WORKSPACE_LOCATION = "de.renew.navigator.workspace";
    public static final String NET_PATH = "de.renew.netPath";
    private final IOLoader _ioLoader;
    private final FileFilterBuilder _fileFilterBuilder;
    private final HashSet<SwingWorker<TreeElement, Void>> _activeWorkers;

    public FilesystemController(NavigatorPlugin plugin, FileFilterBuilder fileFilterBuilder) {
        super(plugin);
        this._fileFilterBuilder = fileFilterBuilder;
        this._ioLoader = new FilesystemIOLoader(fileFilterBuilder);
        this._activeWorkers = new HashSet();
    }

    public boolean isExternallyOpenedFile(File file) {
        return this._fileFilterBuilder.isExternallyOpenedFile(file);
    }

    public void loadRootDirectories(Collection<File> rootDirectories) {
        for (final File rootDir : rootDirectories) {
            this.addLoadingTask(new LoadingTask(){

                @Override
                public String getName() {
                    return String.format("Loading %s ...", rootDir.getName());
                }

                @Override
                public TreeElement performAction(ProgressListener listener) {
                    return FilesystemController.this._ioLoader.loadPath(rootDir, listener);
                }
            });
        }
    }

    public void loadFromProperties() {
        this.cancelAllLoadingTasks();
        this._model.clear();
        PluginProperties properties = this._plugin.getProperties();
        String systemProperty = System.getProperty("user.dir");
        String workspaceLocation = properties.getProperty(WORKSPACE_LOCATION, systemProperty);
        File workspaceDir = new File(workspaceLocation);
        try {
            workspaceDir = workspaceDir.getCanonicalFile();
        }
        catch (IOException e) {
            workspaceDir = new File(systemProperty);
        }
        String filesAtStartup = properties.getProperty(FILES_AT_STARTUP, ".");
        LinkedList<File> files = FilesystemController.getFiles(filesAtStartup, workspaceDir);
        this.loadRootDirectories(files);
    }

    private static LinkedList<File> getFiles(String filesAtStartup, File workspaceDir) {
        LinkedList<File> files = new LinkedList<File>();
        for (String fileName : filesAtStartup.split(";")) {
            File dir = new File(fileName);
            if (!dir.isAbsolute()) {
                dir = new File(workspaceDir, fileName);
            }
            try {
                dir = dir.getCanonicalFile();
                if (!dir.exists() || !dir.isDirectory()) continue;
                files.add(dir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return files;
    }

    public void loadFromNetPaths() {
        IPlugin simulator = PluginManager.getInstance().getPluginByName("Renew Simulator");
        if (simulator == null) {
            throw new RuntimeException("Could not find Simulator plugin.");
        }
        String property = simulator.getProperties().getProperty(NET_PATH);
        if (property == null) {
            throw new RuntimeException("Net path property is not set.");
        }
        String[] paths = StringUtil.splitPaths((String)property);
        PathEntry[] entries = StringUtil.canonizePaths((String[])paths);
        LinkedList<File> files = new LinkedList<File>();
        for (PathEntry entry : entries) {
            if (entry.isClasspathRelative) continue;
            files.add(new File(entry.path));
        }
        this.loadRootDirectories(files);
    }

    public void refreshPaths() {
        this.cancelAllLoadingTasks();
        for (final TreeElement treeRoot : this._model.getTreeRoots()) {
            this.addLoadingTask(new LoadingTask(){

                @Override
                public String getName() {
                    return String.format("Refreshing %s ...", treeRoot.getName());
                }

                @Override
                public TreeElement performAction(ProgressListener listener) {
                    FilesystemController.this._ioLoader.refreshPath(treeRoot, treeRoot.getFile(), listener);
                    return treeRoot;
                }
            });
        }
    }

    public FileFilter getFileFilter() {
        return this._fileFilterBuilder.buildFileFilter();
    }

    private void addLoadingTask(LoadingTask loadingTask) {
        FilesystemController ctrl = this;
        BackgroundTask backgroundTask = new BackgroundTask(loadingTask.getName());
        SwingWorkerExtender worker = new SwingWorkerExtender(loadingTask, ctrl, backgroundTask);
        this._activeWorkers.add(worker);
        worker.execute();
        backgroundTask.setCancelAction(() -> {
            this._activeWorkers.remove(worker);
            worker.cancel(true);
        });
        this._model.addBackgroundTask(backgroundTask);
        this._model.notifyObservers(this);
    }

    private void cancelAllLoadingTasks() {
        Iterator<SwingWorker<TreeElement, Void>> i = this._activeWorkers.iterator();
        while (i.hasNext()) {
            SwingWorker<TreeElement, Void> worker = i.next();
            i.remove();
            worker.cancel(true);
        }
    }

    static interface LoadingTask {
        public String getName();

        public TreeElement performAction(ProgressListener var1);
    }

    private final class SwingWorkerExtender
    extends SwingWorker<TreeElement, Void> {
        private final BackgroundTask _backgroundTask;
        private final LoadingTask _loadingTask;
        private final FilesystemController _ctrl;

        private SwingWorkerExtender(LoadingTask loadingTask, FilesystemController ctrl, BackgroundTask task) {
            this._backgroundTask = task;
            this._loadingTask = loadingTask;
            this._ctrl = ctrl;
        }

        @Override
        protected TreeElement doInBackground() throws Exception {
            ProgressListener listener = new ProgressListener(){

                @Override
                public void progress(float progress, int max) {
                    SwingWorkerExtender.this._backgroundTask.setCurrent(progress / (float)max);
                    SwingWorkerExtender.this._backgroundTask.notifyObservers();
                }

                @Override
                public boolean isWorkerCancelled() {
                    return SwingWorkerExtender.this.isCancelled();
                }
            };
            return this._loadingTask.performAction(listener);
        }

        @Override
        protected void done() {
            FilesystemController.this._model.removeBackgroundTask(this._backgroundTask);
            if (!this.isCancelled()) {
                FilesystemController.this._activeWorkers.remove(this);
                try {
                    TreeElement treeElement = (TreeElement)this.get();
                    if (!FilesystemController.this._model.contains(treeElement)) {
                        FilesystemController.this._model.add(treeElement);
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            FilesystemController.this._model.notifyObservers(this._ctrl);
        }
    }
}

