/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator;

import de.renew.navigator.NavigatorController;
import de.renew.navigator.NavigatorPlugin;
import de.renew.navigator.models.Directory;
import de.renew.navigator.models.DirectoryType;
import de.renew.navigator.models.Leaf;
import de.renew.navigator.models.Model;
import de.renew.navigator.models.SearchFilter;
import de.renew.navigator.models.TreeElement;
import de.renew.plugin.PluginManager;
import java.io.File;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AutosaveController
extends NavigatorController {
    private final DocumentBuilder _documentBuilder;
    private final Transformer _transformer;
    private final File _autosaveFile = new File(PluginManager.getPreferencesLocation(), "navigator.xml");
    private SwingWorker<Document, Object> _worker;
    public static final Logger LOGGER = Logger.getLogger(AutosaveController.class);

    public AutosaveController(NavigatorPlugin plugin) {
        super(plugin);
        try {
            this._documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this._transformer = TransformerFactory.newInstance().newTransformer();
            this._transformer.setOutputProperty("indent", "yes");
            this._transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onModelChanged(Object target) {
        if (this._worker != null && !this._worker.isDone()) {
            LOGGER.trace((Object)"Cancelled old worker.");
            this._worker.cancel(true);
        }
        this._worker = new SwingWorker<Document, Object>(){

            @Override
            protected Document doInBackground() throws Exception {
                return AutosaveController.this.createXmlDocument();
            }

            @Override
            protected void done() {
                if (this.isCancelled()) {
                    return;
                }
                try {
                    DOMSource source = new DOMSource((Node)this.get());
                    StreamResult result = new StreamResult(AutosaveController.this._autosaveFile);
                    try {
                        AutosaveController.this._transformer.transform(source, result);
                    }
                    catch (TransformerException e) {
                        e.printStackTrace();
                    }
                }
                catch (InterruptedException source) {
                }
                catch (ExecutionException e) {
                    LOGGER.error((Object)"Could not create autosave XML file", (Throwable)e);
                }
            }
        };
        this._worker.execute();
    }

    public void loadModel() {
        this._model.clear();
        try {
            Document doc = this._documentBuilder.parse(this._autosaveFile);
            doc.getDocumentElement().normalize();
            Element rootElement = doc.getDocumentElement();
            this._model.setTextSearch(null);
            NodeList textSearchElements = rootElement.getElementsByTagName("text-search");
            if (textSearchElements.getLength() > 0) {
                Element textSearchElement = (Element)textSearchElements.item(0);
                String name = textSearchElement.getAttribute("name");
                SearchFilter.Type type = SearchFilter.Type.valueOf(textSearchElement.getAttribute("type"));
                boolean caseSensitive = Boolean.valueOf(textSearchElement.getAttribute("case-sensitive"));
                NodeList termElements = textSearchElement.getElementsByTagName("term");
                String[] terms = new String[termElements.getLength()];
                for (int j = 0; j < termElements.getLength(); ++j) {
                    Element termElement = (Element)termElements.item(j);
                    terms[j] = termElement.getTextContent();
                }
                SearchFilter textSearch = new SearchFilter(name, type, caseSensitive, terms);
                this._model.setTextSearch(textSearch);
            }
            Element fileFiltersElement = (Element)rootElement.getElementsByTagName("filters").item(0);
            for (int i = 0; i < fileFiltersElement.getChildNodes().getLength(); ++i) {
                Node node = fileFiltersElement.getChildNodes().item(i);
                if (!(node instanceof Element)) continue;
                Element fileFilterElement = (Element)node;
                String name = fileFilterElement.getAttribute("name");
                SearchFilter.Type type = SearchFilter.Type.valueOf(fileFilterElement.getAttribute("type"));
                boolean caseSensitive = Boolean.valueOf(fileFilterElement.getAttribute("case-sensitive"));
                NodeList termElements = fileFilterElement.getElementsByTagName("term");
                String[] terms = new String[termElements.getLength()];
                for (int j = 0; j < termElements.getLength(); ++j) {
                    Element termElement = (Element)termElements.item(j);
                    terms[j] = termElement.getTextContent();
                }
                SearchFilter fileFilter = new SearchFilter(name, type, caseSensitive, terms);
                this._model.activateFileFilter(fileFilter);
            }
            Element treesElement = (Element)rootElement.getElementsByTagName("trees").item(0);
            for (int i = 0; i < treesElement.getChildNodes().getLength(); ++i) {
                Node node = treesElement.getChildNodes().item(i);
                if (!(node instanceof Element)) continue;
                Element treeElement = (Element)node;
                this.loadTreeElementFromXml(this._model, treeElement);
            }
            this._model.notifyObservers(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isAutosaveFileExisting() {
        return this._autosaveFile.exists();
    }

    private Document createXmlDocument() {
        Document doc = this._documentBuilder.newDocument();
        Element rootElement = doc.createElement("navigator");
        doc.appendChild(rootElement);
        if (this._model.getTextSearch() != null) {
            Element textSearchElement = doc.createElement("text-search");
            rootElement.appendChild(textSearchElement);
            this.saveSearchFilterToElement(this._model.getTextSearch(), textSearchElement);
        }
        Element fileFiltersElement = doc.createElement("filters");
        rootElement.appendChild(fileFiltersElement);
        for (SearchFilter fileFilter : this._model.getActiveFileFilters()) {
            Element fileFilterElement = doc.createElement("filter");
            fileFiltersElement.appendChild(fileFilterElement);
            this.saveSearchFilterToElement(fileFilter, fileFilterElement);
        }
        Element xmlTrees = doc.createElement("trees");
        rootElement.appendChild(xmlTrees);
        for (TreeElement element : this._model.getTreeRoots()) {
            this.saveTreeElementToXml(element, xmlTrees);
        }
        return doc;
    }

    private void saveSearchFilterToElement(SearchFilter filter, Element element) {
        element.setAttribute("name", filter.getName());
        element.setAttribute("case-sensitive", String.valueOf(filter.isCaseSensitive()));
        element.setAttribute("type", filter.getType().toString());
        for (String term : filter.getTerms()) {
            Element termsElement = element.getOwnerDocument().createElement("term");
            element.appendChild(termsElement);
            termsElement.setTextContent(term);
        }
    }

    private void saveTreeElementToXml(TreeElement treeElement, Element xml) {
        String elementName = this.treeElementToName(treeElement);
        Element childXml = xml.getOwnerDocument().createElement(elementName);
        xml.appendChild(childXml);
        childXml.setAttribute("name", treeElement.getName());
        childXml.setAttribute("excluded", String.valueOf(treeElement.isExcluded()));
        childXml.setAttribute("file", treeElement.getFile().toString());
        if (treeElement instanceof Directory) {
            Directory directory = (Directory)treeElement;
            childXml.setAttribute("opened", String.valueOf(directory.isOpened()));
            if (directory.getType() != null) {
                childXml.setAttribute("type", directory.getType().toString());
            }
            for (TreeElement childElement : directory.getChildren()) {
                this.saveTreeElementToXml(childElement, childXml);
            }
        }
    }

    private void loadTreeElementFromXml(Model parent, Element xml) {
        TreeElement treeElement = this.nameToTreeElement(xml.getTagName());
        parent.add(treeElement);
        treeElement.setName(xml.getAttribute("name"));
        treeElement.setExcluded(Boolean.valueOf(xml.getAttribute("excluded")));
        treeElement.setFile(new File(xml.getAttribute("file")));
        if (treeElement instanceof Directory) {
            Directory directory = (Directory)treeElement;
            directory.setOpened(Boolean.valueOf(xml.getAttribute("opened")));
            if (xml.hasAttribute("type")) {
                directory.setType(DirectoryType.valueOf(xml.getAttribute("type")));
            } else {
                directory.setType(null);
            }
            for (int i = 0; i < xml.getChildNodes().getLength(); ++i) {
                Node node = xml.getChildNodes().item(i);
                if (!(node instanceof Element)) continue;
                this.loadTreeElementFromXml(directory, (Element)node);
            }
        }
    }

    private TreeElement nameToTreeElement(String elementName) {
        if (elementName.equals("file")) {
            return new Leaf();
        }
        return new Directory();
    }

    private String treeElementToName(TreeElement treeElement) {
        Class<?> treeElementClass = treeElement.getClass();
        if (treeElementClass.equals(Leaf.class)) {
            return "file";
        }
        return "directory";
    }
}

