/*
 * Decompiled with CFR 0.152.
 */
package de.renew.imagenetdiff;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.ExportHolderImpl;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import de.renew.export.io.exportFormats.EPSExportFormat;
import de.renew.imagenetdiff.AbstractDiffCommand;
import de.renew.imagenetdiff.PNGDiffCommand;
import de.renew.util.StringUtil;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.log4j.Logger;

public class EPSDiffCommand
extends AbstractDiffCommand {
    static final Logger LOGGER = Logger.getLogger(EPSDiffCommand.class);
    private static final String IMAGE_EXTENSION = ".eps";

    public EPSDiffCommand() {
        super("Simple EPS Diff");
        this.setImageExtension(IMAGE_EXTENSION);
    }

    @Override
    public File doDiff(StatusDisplayer sd, Drawing drawing1, Drawing drawing2, boolean quite) {
        if (drawing1 != null && drawing2 != null) {
            ExportHolderImpl exporter = (ExportHolderImpl)Objects.requireNonNull(DrawPlugin.getCurrent()).getExportHolder();
            ExportFormat[] exportFormats = exporter.allExportFormats();
            EPSExportFormat export = null;
            for (int i = 0; i < exportFormats.length; ++i) {
                if (!(exportFormats[i] instanceof EPSExportFormat)) continue;
                export = (EPSExportFormat)exportFormats[i];
                break;
            }
            if (export == null) {
                System.out.println("sorry");
                return null;
            }
            String fileName1 = drawing1.getName();
            String fileName2 = drawing2.getName();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)(PNGDiffCommand.class.getSimpleName() + ": fileName1 " + fileName1));
                LOGGER.info((Object)(PNGDiffCommand.class.getSimpleName() + ": fileName2 " + fileName2));
            }
            Rectangle bounds1 = drawing1.getBounds();
            Rectangle bounds2 = drawing2.getBounds();
            int width = Math.max(bounds1.width + bounds1.x, bounds2.width + bounds2.x);
            int height = Math.max(bounds1.height + bounds1.y, bounds2.height + bounds2.y);
            Rectangle bounds = new Rectangle(0, 0, width, height);
            File tempFile1 = null;
            File tempFile2 = null;
            try {
                tempFile1 = File.createTempFile("export-", fileName1 + this.getImageExtension());
                tempFile2 = File.createTempFile("export-", fileName2 + this.getImageExtension());
            }
            catch (IOException e2) {
                LOGGER.error((Object)e2.getMessage());
                LOGGER.debug((Object)e2.getMessage(), (Throwable)e2);
            }
            if (tempFile1 != null && tempFile2 != null) {
                Process process;
                String nameDiff;
                String nameDiffNoExt;
                block25: {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)(PNGDiffCommand.class.getSimpleName() + ": tempFile1 " + tempFile1.getAbsolutePath()));
                    }
                    try {
                        export.internalExport(drawing1, tempFile1, bounds, true);
                        export.internalExport(drawing2, tempFile2, bounds, true);
                    }
                    catch (Exception e1) {
                        LOGGER.error((Object)e1.getMessage());
                        LOGGER.debug((Object)e1.getMessage(), (Throwable)e1);
                    }
                    String name1 = StringUtil.stripFilenameExtension((String)tempFile1.getAbsolutePath());
                    String name2 = StringUtil.stripFilenameExtension((String)tempFile2.getAbsolutePath());
                    nameDiffNoExt = name1 + "-diff";
                    nameDiff = name1 + "-diff" + this.getImageExtension();
                    this.exchangeColor(name1, 10, "white", "white");
                    this.exchangeColor(name2, 10, "white", "white");
                    if (drawing1.getFilename() != null && (drawing1.getFilename().getName().endsWith(".aip") || drawing1.getFilename().getName().endsWith(".rnw"))) {
                        LOGGER.debug((Object)"Doing AIP/RNW conversion.");
                        this.exchangeColor(name1, 10, "lightgray", "white");
                        this.exchangeColor(name1, 10, "lightgreen", "white");
                        this.exchangeColor(name2, 10, "lightgray", "white");
                        this.exchangeColor(name2, 10, "lightgreen", "white");
                        this.exchangeColor(name1, 10, "seagreen1", "white");
                        this.exchangeColor(name2, 10, "seagreen1", "white");
                        this.exchangeColor(name1, 10, "yellow", "white");
                        this.exchangeColor(name2, 10, "yellow", "white");
                    }
                    process = null;
                    try {
                        process = Runtime.getRuntime().exec("compare " + name2 + this.getImageExtension() + " " + name1 + this.getImageExtension() + " " + nameDiff);
                    }
                    catch (Exception e1) {
                        LOGGER.error((Object)("Error while executing imagemagick compare: " + e1.getMessage()));
                        if (!LOGGER.isDebugEnabled()) break block25;
                        LOGGER.debug((Object)(PNGDiffCommand.class.getSimpleName() + ": " + e1.getMessage()), (Throwable)e1);
                    }
                }
                if (process != null) {
                    try {
                        int exit = process.waitFor();
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)(EPSDiffCommand.class.getSimpleName() + ": process' exit code = " + exit));
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.exchangeColor(nameDiffNoExt, 10, "#d81030", "green");
                File diffFile = new File(nameDiff);
                if (!diffFile.exists()) {
                    sd.showStatus("Could not create diff image. ImageMagick installed?");
                } else if (!quite) {
                    try {
                        Runtime.getRuntime().exec("gv " + String.valueOf(diffFile));
                    }
                    catch (IOException e1) {
                        LOGGER.error((Object)e1.getMessage());
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)(EPSDiffCommand.class.getName() + ": "), (Throwable)e1);
                        }
                    }
                } else {
                    sd.showStatus("Diff image created successfully. Name: " + diffFile.getName());
                }
                return diffFile;
            }
        } else {
            sd.showStatus("Operation canceled.");
        }
        return null;
    }
}

