/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundAlgorithmListener;
import bibliothek.gui.dock.util.PaintableComponent;
import bibliothek.gui.dock.util.Transparency;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public abstract class BackgroundPanel
extends JPanel
implements PaintableComponent {
    private BackgroundAlgorithm background;
    private Transparency transparency;
    private BackgroundAlgorithmListener listener = new BackgroundAlgorithmListener(){

        public void transparencyChanged(BackgroundAlgorithm algorithm, Transparency transparency) {
            BackgroundPanel.this.configure(transparency);
        }
    };

    public BackgroundPanel(Transparency transparency) {
        this.setTransparency(transparency);
    }

    public BackgroundPanel(LayoutManager layout, Transparency transparency) {
        super(layout);
        this.setTransparency(transparency);
    }

    public void setBackground(BackgroundAlgorithm background) {
        if (this.background != null) {
            this.background.removeListener(this.listener);
        }
        this.background = background;
        if (background != null) {
            background.addListener(this.listener);
            this.configure(background.getTransparency());
        }
    }

    protected abstract void configure(Transparency var1);

    public BackgroundAlgorithm getBackgroundAlgorithm() {
        return this.background;
    }

    public void paint(Graphics g) {
        this.setupRenderingHints(g);
        if (this.background == null || this.background.getPaint() == null) {
            super.paint(g);
            this.paintOverlay(g);
        } else {
            this.background.paint(this, g);
        }
    }

    protected abstract void setupRenderingHints(Graphics var1);

    protected void paintComponent(Graphics g) {
        this.paintBackground(g);
        this.paintForeground(g);
    }

    public void setTransparency(Transparency transparency) {
        this.transparency = transparency;
        this.setOpaque(transparency == Transparency.SOLID);
    }

    public Transparency getTransparency() {
        return this.transparency;
    }

    public Component getComponent() {
        return this;
    }

    public void paintBackground(Graphics g) {
        if (this.transparency != Transparency.TRANSPARENT) {
            super.paintComponent(g);
        }
    }

    public void paintForeground(Graphics g) {
    }

    public void paintBorder(Graphics g) {
        super.paintBorder(g);
    }

    public void paintChildren(Graphics g) {
        super.paintChildren(g);
    }

    public void paintOverlay(Graphics g) {
    }
}

