/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab.layouting;

import java.awt.Dimension;

public class Size {
    private Type type;
    private int width;
    private int height;
    private double score;

    public Size(Type type, int width, int height, double score) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (score < 0.0 || score > 1.0) {
            throw new IllegalArgumentException("score out of bounds: " + score);
        }
        this.score = score;
        this.type = type;
        this.width = width;
        this.height = height;
    }

    public Size(Type type, Dimension size, double score) {
        this(type, size.width, size.height, score);
    }

    public boolean isMinimum() {
        return Type.MINIMUM == this.type;
    }

    public boolean isPreferred() {
        return Type.PREFERRED == this.type;
    }

    public Type getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getScore() {
        return this.score;
    }

    public Dimension toDimension() {
        return new Dimension(this.width, this.height);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@[width=" + this.getWidth() + ", height=" + this.getHeight() + ", type=" + (Object)((Object)this.getType()) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        MINIMUM,
        PREFERRED;

    }
}

