/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Path;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSplitPlaceholderConverter<P, N, D> {
    private P station;

    public AbstractSplitPlaceholderConverter(P station) {
        this.station = station;
    }

    public P getStation() {
        return this.station;
    }

    public PlaceholderMap getPlaceholders() {
        PlaceholderMap result = new PlaceholderMap(new Path("dock.SplitDockStation"), 0);
        this.handleChild(result, this.getRoot(this.station), "");
        return result;
    }

    public void setPlaceholders(PlaceholderMap map) {
        map = map.filter(this.getPlaceholderStrategy(this.station));
        PlaceholderMap.Key[] keys = map.getPlaceholders();
        BuildNode root = new BuildNode();
        for (PlaceholderMap.Key key : keys) {
            this.handleEntry(key, map, root);
        }
        SplitDockTree<D> tree = this.createTree();
        root.collapse(tree);
        this.dropTree(this.station, tree);
    }

    protected abstract N getRoot(P var1);

    protected abstract PlaceholderStrategy getPlaceholderStrategy(P var1);

    protected abstract boolean isRoot(N var1);

    protected abstract boolean isNode(N var1);

    protected abstract boolean isLeaf(N var1);

    protected abstract boolean isPlaceholder(N var1);

    protected abstract Path[] getPlaceholders(N var1);

    protected abstract PlaceholderMap getPlaceholderMap(N var1);

    protected abstract long getId(N var1);

    protected abstract N getRootChild(N var1);

    protected abstract N getLeftChild(N var1);

    protected abstract N getRightChild(N var1);

    protected abstract double getDivider(N var1);

    protected abstract SplitDockStation.Orientation getOrientation(N var1);

    protected abstract D getDockable(N var1);

    protected abstract Path getPlaceholderFor(D var1);

    protected abstract SplitDockTree<D> createTree();

    protected abstract void dropTree(P var1, SplitDockTree<D> var2);

    private Set<Path> handleChild(PlaceholderMap result, N node, String path) {
        if (this.isRoot(node)) {
            return this.handleRoot(result, node, path);
        }
        if (this.isNode(node)) {
            return this.handleNode(result, node, path);
        }
        if (this.isLeaf(node)) {
            return this.handleLeaf(result, node, path);
        }
        if (this.isPlaceholder(node)) {
            return this.handlePlaceholder(result, node, path);
        }
        return null;
    }

    private PlaceholderMap.Key handleBase(PlaceholderMap result, N node, String path, Set<Path> allPlaceholders, Set<Path> localPlaceholders) {
        Path[] array = this.getPlaceholders(node);
        PlaceholderMap map = this.getPlaceholderMap(node);
        if (array != null) {
            for (Path key : array) {
                allPlaceholders.add(key);
                if (localPlaceholders == null) {
                    localPlaceholders = new HashSet<Path>();
                }
                localPlaceholders.add(key);
            }
        }
        if (!allPlaceholders.isEmpty()) {
            PlaceholderMap.Key key = result.newKey(allPlaceholders.toArray(new Path[allPlaceholders.size()]));
            result.putLong(key, path + ".id", this.getId(node));
            if (map != null) {
                result.putMap(key, path + ".map", map.copy());
            }
            if (localPlaceholders != null && !localPlaceholders.isEmpty()) {
                PlaceholderMap.Key arrayKey = result.newKey(localPlaceholders.toArray(new Path[localPlaceholders.size()]));
                result.put(arrayKey, path + ".array", true);
            }
            return key;
        }
        return null;
    }

    private Set<Path> handleRoot(PlaceholderMap result, N root, String path) {
        PlaceholderMap.Key key;
        Set<Path> set = this.handleChild(result, this.getRootChild(root), path + "0");
        if (set != null && (key = this.handleBase(result, root, path, set, null)) != null) {
            result.putString(key, path + ".type", "r");
            return set;
        }
        return null;
    }

    private Set<Path> handleNode(PlaceholderMap result, N node, String path) {
        Set<Path> all;
        Set<Path> left = this.handleChild(result, this.getLeftChild(node), path + "0");
        Set<Path> right = this.handleChild(result, this.getRightChild(node), path + "1");
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            all = right;
        } else if (right == null) {
            all = left;
        } else {
            all = left;
            all.addAll(right);
        }
        PlaceholderMap.Key key = this.handleBase(result, node, path, all, null);
        if (key != null) {
            result.putString(key, path + ".type", "n");
            result.putDouble(key, path + ".divider", this.getDivider(node));
            result.putBoolean(key, path + ".orientation", this.getOrientation(node) == SplitDockStation.Orientation.HORIZONTAL);
            return all;
        }
        return null;
    }

    private Set<Path> handlePlaceholder(PlaceholderMap result, N placeholder, String path) {
        HashSet<Path> set = new HashSet<Path>();
        PlaceholderMap.Key key = this.handleBase(result, placeholder, path, set, null);
        if (key != null) {
            result.putString(key, path + ".type", "p");
            return set;
        }
        return null;
    }

    private Set<Path> handleLeaf(PlaceholderMap result, N leaf, String path) {
        Object key;
        HashSet<Path> set = new HashSet<Path>();
        HashSet<Path> local = new HashSet<Path>();
        D dockable = this.getDockable(leaf);
        if (dockable != null && (key = this.getPlaceholderFor(dockable)) != null) {
            set.add((Path)key);
            local.add((Path)key);
        }
        if ((key = this.handleBase(result, leaf, path, set, local)) != null) {
            result.putString((PlaceholderMap.Key)key, path + ".type", "l");
            return set;
        }
        return null;
    }

    private void handleEntry(PlaceholderMap.Key key, PlaceholderMap map, BuildNode root) {
        for (String item : map.getKeys(key)) {
            BuildNode node = root.get(this.path(item));
            String itemKey = this.key(item);
            if ("type".equals(itemKey)) {
                node.type = map.getString(key, item);
                continue;
            }
            if ("id".equals(itemKey)) {
                node.id = map.getLong(key, item);
                continue;
            }
            if ("map".equals(itemKey)) {
                node.map = map.getMap(key, item);
                continue;
            }
            if ("array".equals(itemKey)) {
                BuildNode.access$402(node, key.getPlaceholders());
                continue;
            }
            if ("divider".equals(itemKey)) {
                node.divider = map.getDouble(key, item);
                continue;
            }
            if (!"orientation".equals(itemKey)) continue;
            node.orientation = map.getBoolean(key, item);
        }
    }

    private String path(String item) {
        return item.substring(0, item.indexOf(46));
    }

    private String key(String item) {
        return item.substring(item.indexOf(46) + 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BuildNode {
        private BuildNode[] children;
        private long id = -1L;
        private String type;
        private Path[] placeholders;
        private PlaceholderMap map;
        private boolean orientation;
        private double divider = 0.5;

        private BuildNode() {
        }

        public BuildNode get(String path) {
            return this.get(path, 0);
        }

        private BuildNode get(String path, int index) {
            if (index == path.length()) {
                return this;
            }
            if ('0' == path.charAt(index)) {
                return this.get(0).get(path, index + 1);
            }
            return this.get(1).get(path, index + 1);
        }

        private BuildNode[] createArray(int length) {
            return new BuildNode[length];
        }

        private BuildNode get(int index) {
            if (this.children == null) {
                this.children = this.createArray(index + 1);
            }
            if (this.children.length <= index) {
                BuildNode[] temp = this.createArray(index + 1);
                System.arraycopy(this.children, 0, temp, 0, this.children.length);
                this.children = temp;
            }
            if (this.children[index] == null) {
                this.children[index] = new BuildNode();
            }
            return this.children[index];
        }

        public SplitDockTree.Key collapse(SplitDockTree<D> tree) {
            if ("l".equals(this.type) || "p".equals(this.type)) {
                if (this.placeholders != null && this.placeholders.length > 0) {
                    return tree.put(this.placeholders, this.map, this.id);
                }
                return null;
            }
            if ("n".equals(this.type)) {
                SplitDockTree.Key left = null;
                SplitDockTree.Key right = null;
                if (this.children != null && this.children.length > 0 && this.children[0] != null) {
                    left = this.children[0].collapse(tree);
                }
                if (this.children != null && this.children.length > 1 && this.children[1] != null) {
                    right = this.children[1].collapse(tree);
                }
                if (left == null) {
                    return right;
                }
                if (right == null) {
                    return left;
                }
                if (this.orientation) {
                    return tree.horizontal(left, right, this.divider, this.placeholders, this.map, this.id);
                }
                return tree.vertical(left, right, this.divider, this.placeholders, this.map, this.id);
            }
            if ("r".equals(this.type)) {
                SplitDockTree.Key child;
                if (this.children != null && this.children.length > 0 && this.children[0] != null && (child = this.children[0].collapse(tree)) != null) {
                    tree.root(child);
                    return child;
                }
                return null;
            }
            return null;
        }

        static /* synthetic */ Path[] access$402(BuildNode x0, Path[] x1) {
            x0.placeholders = x1;
            return x1;
        }
    }
}

