/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.layout.location;

import bibliothek.gui.DockStation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.location.AsideAnswer;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.layout.location.DefaultAsideAnswer;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.util.Path;

public class DefaultAsideRequest
implements AsideRequest {
    private DockableProperty location;
    private Path placeholder;
    private DockStation parent;
    private Forward current;
    private DockableProperty resultingLocation;
    private PlaceholderMap resultingLayout;
    private boolean hasAnswer = false;
    private AsideAnswer successorAnswer;

    public DefaultAsideRequest(DockableProperty location, Path placeholder) {
        this.location = location;
        this.placeholder = placeholder;
    }

    protected DefaultAsideRequest createForwardRequest(DockableProperty location) {
        return new DefaultAsideRequest(location, this.getPlaceholder());
    }

    public DockableProperty getLocation() {
        return this.location;
    }

    public Path getPlaceholder() {
        return this.placeholder;
    }

    public PlaceholderMap getLayout() {
        return this.current.getLayout();
    }

    public DockStation getParentStation() {
        return this.parent;
    }

    protected void setParentStation(DockStation parent) {
        this.parent = parent;
    }

    public void answer() {
        this.answer((DockableProperty)null);
    }

    public void answer(DockableProperty location) {
        this.hasAnswer = true;
        this.resultingLocation = location;
    }

    public void answer(PlaceholderMap station) {
        this.hasAnswer = true;
        this.resultingLayout = station;
    }

    public void answer(DockableProperty location, PlaceholderMap station) {
        this.answer(location);
        this.answer(station);
    }

    protected void setCurrent(Forward current) {
        this.current = current;
        this.resultingLayout = current.getLayout();
    }

    public AsideAnswer execute(DockStation station) {
        this.setCurrent(new DockStationForward(station));
        return this.execute();
    }

    protected AsideAnswer execute() {
        if (this.hasAnswer) {
            throw new IllegalStateException("this request is already used, it cannot be executed a second time");
        }
        this.current.execute(this);
        if (this.hasAnswer) {
            this.hasAnswer = true;
            DockableProperty location = this.answerLocation(this.successorAnswer);
            return new DefaultAsideAnswer(false, location, this.resultingLayout);
        }
        return new DefaultAsideAnswer(true, null, null);
    }

    private DockableProperty answerLocation(AsideAnswer successor) {
        if (successor == null || successor.getLocation() == null) {
            return this.resultingLocation;
        }
        if (this.resultingLocation == null) {
            return successor.getLocation();
        }
        DockableProperty last = this.resultingLocation;
        while (last.getSuccessor() != null) {
            last = last.getSuccessor();
        }
        last.setSuccessor(successor.getLocation());
        return this.resultingLocation;
    }

    public AsideAnswer forward(DockStation station) {
        return this.forward(new DockStationForward(station));
    }

    public AsideAnswer forward(Combiner combiner) {
        return this.forward(new CombinerForward(combiner, null));
    }

    public AsideAnswer forward(Combiner combiner, PlaceholderMap layout) {
        return this.forward(new CombinerForward(combiner, layout));
    }

    protected AsideAnswer forward(Forward forward) {
        DockableProperty successor = null;
        if (this.location != null) {
            successor = this.location.getSuccessor();
        }
        DefaultAsideRequest request = this.createForwardRequest(successor);
        request.setCurrent(forward);
        request.setParentStation(this.current.getStation());
        this.successorAnswer = request.execute();
        return this.successorAnswer;
    }

    protected static class CombinerForward
    implements Forward {
        private Combiner combiner;
        private PlaceholderMap layout;

        public CombinerForward(Combiner combiner, PlaceholderMap layout) {
            this.combiner = combiner;
            this.layout = layout;
        }

        public PlaceholderMap getLayout() {
            return this.layout;
        }

        public void execute(AsideRequest request) {
            this.combiner.aside(request);
        }

        public DockStation getStation() {
            return null;
        }
    }

    protected static class DockStationForward
    implements Forward {
        private DockStation station;

        public DockStationForward(DockStation station) {
            this.station = station;
        }

        public PlaceholderMap getLayout() {
            return null;
        }

        public void execute(AsideRequest request) {
            this.station.aside(request);
        }

        public DockStation getStation() {
            return this.station;
        }
    }

    protected static interface Forward {
        public PlaceholderMap getLayout();

        public DockStation getStation();

        public void execute(AsideRequest var1);
    }
}

