/*
 * Decompiled with CFR 0.152.
 */
package de.renew.export.io.exportFormats;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import de.renew.export.io.exportFormats.EPSExportFormat;
import de.renew.export.io.exportFormats.ExportClCommand;
import de.renew.export.io.exportFormats.PDFExportFormat;
import de.renew.export.io.exportFormats.PNGExportFormat;
import de.renew.export.io.exportFormats.SVGExportFormat;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import java.net.URL;
import org.apache.log4j.Logger;
import org.freehep.graphicsio.PageConstants;

public class ExportPlugin
extends PluginAdapter {
    public static final Logger LOGGER = Logger.getLogger(ExportPlugin.class);
    public static final String NO_EMEDED_FONTS_PROPERTY = "de.renew.io.exportFormats.svg-no-embeded-fonts";
    private EPSExportFormat _epsExport;
    private PDFExportFormat _pdfExport;
    private SVGExportFormat _svgExport;
    private PNGExportFormat _pngExport;
    public static final String PAGE_SIZE_PROP_NAME = "de.renew.io.export.pageSize";
    public static final String PAGE_ORIENTATION_PROP_NAME = "de.renew.io.export.pageOrientation";
    public static final String PAGE_MARGINS_PROP_NAME = "de.renew.io.export.pageMargins";
    public static final String EPS_FONT_HANDLING_PROP_NAME = "de.renew.io.export.epsFontHandling";
    public static final String EPS_FONT_HANDLING_EMBED = "embed";
    public static final String EPS_FONT_HANDLING_NONE = "none";
    public static final String EPS_FONT_HANDLING_SHAPES = "shapes";
    public static final String[] EPS_FONT_HANDLING_PROP_VALUES = new String[]{"embed", "none", "shapes"};
    private static final String EPS_TRANSPARENCY_PROP_NAME = "de.renew.io.export.eps-transparency";
    public static final String BOUNDING_BOX_PAGE_SIZE = "BoundingBox";

    public ExportPlugin(URL location) throws PluginException {
        super(location);
    }

    public ExportPlugin(PluginProperties props) {
        super(props);
    }

    public boolean cleanup() {
        DrawPlugin current = DrawPlugin.getCurrent();
        if (current == null) {
            return true;
        }
        current.getExportHolder().removeExportFormat((ExportFormat)this._epsExport);
        current.getExportHolder().removeExportFormat((ExportFormat)this._pdfExport);
        current.getExportHolder().removeExportFormat((ExportFormat)this._svgExport);
        current.getExportHolder().removeExportFormat((ExportFormat)this._pngExport);
        PluginManager.getInstance().removeCLCommand("ex");
        return true;
    }

    public String getAlias() {
        return "export";
    }

    public void init() {
        DrawPlugin current = DrawPlugin.getCurrent();
        if (current == null) {
            return;
        }
        this._epsExport = new EPSExportFormat();
        this._pdfExport = new PDFExportFormat();
        this._svgExport = new SVGExportFormat();
        this._pngExport = new PNGExportFormat();
        current.getExportHolder().addExportFormat((ExportFormat)this._epsExport);
        current.getExportHolder().addExportFormat((ExportFormat)this._pdfExport);
        current.getExportHolder().addExportFormat((ExportFormat)this._svgExport);
        current.getExportHolder().addExportFormat((ExportFormat)this._pngExport);
        PluginManager.getInstance().addCLCommand("ex", (CLCommand)new ExportClCommand());
    }

    public static ExportPlugin getCurrent() {
        for (Object o : PluginManager.getInstance().getPluginsProviding("de.renew.io.export")) {
            if (!(o instanceof ExportPlugin)) continue;
            return (ExportPlugin)((Object)o);
        }
        return null;
    }

    public String getPageSize() {
        String result = BOUNDING_BOX_PAGE_SIZE;
        String userValue = this.getProperties().getProperty(PAGE_SIZE_PROP_NAME, "A4");
        LOGGER.debug((Object)("Page Size user = " + userValue));
        for (String s : PageConstants.getSizeList()) {
            if (!s.equalsIgnoreCase(userValue)) continue;
            result = s;
            this.getProperties().setProperty(PAGE_SIZE_PROP_NAME, s);
            break;
        }
        if (userValue.equalsIgnoreCase(BOUNDING_BOX_PAGE_SIZE)) {
            result = BOUNDING_BOX_PAGE_SIZE;
            this.getProperties().setProperty(PAGE_SIZE_PROP_NAME, BOUNDING_BOX_PAGE_SIZE);
        }
        LOGGER.debug((Object)("Page Size = " + result));
        return result;
    }

    public String getPageOrientation() {
        String result = "Portrait";
        String userValue = this.getProperties().getProperty(PAGE_ORIENTATION_PROP_NAME, "Portrait");
        LOGGER.debug((Object)("Page orientation user = " + userValue));
        if (userValue.equalsIgnoreCase("Portrait")) {
            result = "Portrait";
            this.getProperties().setProperty(PAGE_ORIENTATION_PROP_NAME, result);
        } else if (userValue.equalsIgnoreCase("Landscape")) {
            result = "Landscape";
            this.getProperties().setProperty(PAGE_ORIENTATION_PROP_NAME, result);
        }
        LOGGER.debug((Object)("Page orientation = " + result));
        return result;
    }

    public String getEpsFontHandling() {
        String result = EPS_FONT_HANDLING_SHAPES;
        String userValue = this.getProperties().getProperty(EPS_FONT_HANDLING_PROP_NAME, EPS_FONT_HANDLING_SHAPES);
        LOGGER.debug((Object)("EPS font handling user = " + userValue));
        for (String s : EPS_FONT_HANDLING_PROP_VALUES) {
            if (!s.equalsIgnoreCase(userValue)) continue;
            result = s;
            this.getProperties().setProperty(EPS_FONT_HANDLING_PROP_NAME, result);
            break;
        }
        LOGGER.debug((Object)("EPS font handling = " + result));
        return result;
    }

    public boolean getEpsTransparency() {
        boolean result = this.getProperties().getBoolProperty(EPS_TRANSPARENCY_PROP_NAME);
        LOGGER.debug((Object)("EPS tansparency user = " + result));
        return result;
    }
}

