/*
 * Decompiled with CFR 0.152.
 */
package de.renew.guiprompt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class ResponseDocument
extends PlainDocument {
    public static final Logger LOGGER = Logger.getLogger(ResponseDocument.class);
    private final BufferedReader _reader;
    private boolean _terminated = false;
    private Object _monitor = new Object();
    private Thread _responseReaderThread;

    public ResponseDocument(PipedOutputStream stream) throws IOException {
        this._reader = new BufferedReader(new InputStreamReader(new PipedInputStream(stream)));
        this._responseReaderThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!ResponseDocument.this._terminated) {
                    try {
                        ResponseDocument.this.appendText(ResponseDocument.this._reader.readLine());
                    }
                    catch (IOException e) {
                        if ("Write end dead".equals(e.getMessage())) {
                            ResponseDocument.this.appendText("\n----\n");
                            Object object = ResponseDocument.this._monitor;
                            synchronized (object) {
                                try {
                                    ResponseDocument.this._monitor.wait();
                                }
                                catch (InterruptedException e2) {
                                    LOGGER.debug((Object)"Feedback thread interrupted.");
                                    ResponseDocument.this.appendText("\nFeedback thread interrupted.");
                                    ResponseDocument.this.terminate();
                                }
                                continue;
                            }
                        }
                        LOGGER.debug((Object)("Feedback exception: " + String.valueOf(e)), (Throwable)e);
                        ResponseDocument.this.appendText("\nFeedback exception: " + String.valueOf(e));
                        ResponseDocument.this.terminate();
                    }
                }
                ResponseDocument.this.appendText("\nFeedback terminated. Press [Clear] to reinitialize.");
            }
        };
        this._responseReaderThread.setName("GuiPrompt feedback reader thread");
        this._responseReaderThread.start();
    }

    public void appendText(String line) {
        try {
            this.insertString(this.getLength(), line + "\n", null);
        }
        catch (BadLocationException e) {
            LOGGER.error((Object)("Bad location!? getLength=" + this.getLength()), (Throwable)e);
        }
    }

    public void terminate() {
        this._terminated = true;
        this._responseReaderThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revive() {
        Object object = this._monitor;
        synchronized (object) {
            this._monitor.notifyAll();
        }
    }
}

