/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.action.predefined.CExternalizeAction;
import bibliothek.gui.dock.common.action.predefined.CUnmaximizeExternalizedAction;
import bibliothek.gui.dock.common.mode.CExternalizedModeArea;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.common.mode.CModeArea;
import bibliothek.gui.dock.common.mode.KeyedLocationModeActionProvider;
import bibliothek.gui.dock.common.perspective.mode.CExternalizedModePerspective;
import bibliothek.gui.dock.common.perspective.mode.LocationModePerspective;
import bibliothek.gui.dock.facile.mode.ExternalizedMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.MappingLocationModeActionProvider;
import bibliothek.gui.dock.support.mode.Mode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CExternalizedMode
extends ExternalizedMode<CExternalizedModeArea>
implements CLocationMode {
    private CControl control;
    private LocationModeActionProvider externalize;
    private LocationModeActionProvider unmaximize;

    public CExternalizedMode(CControl control) {
        this.control = control;
        this.externalize = new KeyedLocationModeActionProvider("cdockable.externalize", new CExternalizeAction(control));
        this.unmaximize = new KeyedLocationModeActionProvider("cdockable.unmaximize_externalized", new CUnmaximizeExternalizedAction(control));
        this.setActionProvider(new MappingLocationModeActionProvider(){

            @Override
            protected LocationModeActionProvider getProvider(Dockable dockable, Mode<Location> currentMode, DockActionSource currentSource) {
                if (currentMode instanceof CMaximizedMode && ((CMaximizedMode)currentMode).getUnmaximizedMode(dockable) instanceof CExternalizedMode) {
                    return CExternalizedMode.this.unmaximize;
                }
                return CExternalizedMode.this.externalize;
            }
        });
    }

    @Override
    public CLocation getCLocation(Dockable dockable) {
        CExternalizedModeArea area = (CExternalizedModeArea)this.get(dockable);
        if (area == null) {
            return null;
        }
        return area.getCLocation(dockable);
    }

    @Override
    public CLocation getCLocation(Dockable dockable, Location location) {
        CModeArea area = (CModeArea)this.get(location.getRoot());
        if (area == null) {
            return null;
        }
        return area.getCLocation(dockable, location);
    }

    @Override
    public boolean isBasicMode() {
        return true;
    }

    @Override
    public boolean respectWorkingAreas(DockStation station) {
        CStation<?> cstation;
        CModeArea area = (CModeArea)this.get(station);
        if (area == null) {
            return true;
        }
        if (area.getStation() != station && ((cstation = this.control.findStation(station)) == null || cstation.getStation() != area.getStation())) {
            return true;
        }
        return area.respectWorkingAreas();
    }

    @Override
    public LocationModePerspective createPerspective() {
        return new CExternalizedModePerspective();
    }
}

