/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.vc;

import de.renew.navigator.vc.Commit;
import de.renew.navigator.vc.Repository;
import de.renew.navigator.vc.VersionControl;
import de.renew.util.StringUtil;
import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractRepository
implements Repository {
    private final File _rootDirectory;
    private final VersionControl _versionControl;
    private final Set<File> _ignored;
    private final Set<File> _added;
    private final Set<File> _modified;
    private Commit _lastCommit;

    public AbstractRepository(File rootDirectory, VersionControl versionControl) {
        this._rootDirectory = rootDirectory;
        this._versionControl = versionControl;
        this._lastCommit = null;
        this._ignored = new HashSet<File>();
        this._added = new HashSet<File>();
        this._modified = new HashSet<File>();
    }

    public final void clearFileSets() {
        this._ignored.clear();
        this._added.clear();
        this._modified.clear();
    }

    public final void addAllToIgnored(Set<File> files) {
        this._ignored.addAll(files);
    }

    public final void addAllToAdded(Set<File> files) {
        this._added.addAll(files);
    }

    public final void addAllToModified(Set<File> files) {
        this._modified.addAll(files);
    }

    public void setLastCommit(Commit lastCommit) {
        this._lastCommit = lastCommit;
    }

    @Override
    public final File getRootDirectory() {
        return this._rootDirectory;
    }

    @Override
    public final VersionControl getVersionControl() {
        return this._versionControl;
    }

    @Override
    public Commit getLastCommit() {
        return this._lastCommit;
    }

    @Override
    public final URI makeRelativeURI(File fileInRepository) {
        return StringUtil.makeRelative((URI)this._rootDirectory.toURI(), (URI)fileInRepository.toURI());
    }

    public String toString() {
        return "[" + this._rootDirectory.toString() + "] " + this._versionControl.getName() + "@" + this.getBranch();
    }

    @Override
    public final Set<File> getIgnored() {
        return this._ignored;
    }

    @Override
    public final Set<File> getAdded() {
        return this._added;
    }

    @Override
    public final Set<File> getModified() {
        return this._modified;
    }

    protected abstract Commit retrieveLastCommit();
}

