/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.importFormats;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.importFormats.ImportFormatAbstract;
import de.renew.gui.pnml.PNMLFormat;
import de.renew.io.PNMLFileFilter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class PNMLImportFormat
extends ImportFormatAbstract {
    public PNMLImportFormat() {
        super("PNML", (FileFilter)((Object)new PNMLFileFilter()));
    }

    public List<Drawing> importFiles(URL[] files) throws Exception {
        ArrayList<Drawing> list = new ArrayList<Drawing>();
        if (files != null) {
            for (URL file : files) {
                list.addAll(this.importFile(file));
            }
        }
        return list;
    }

    protected List<Drawing> importFile(URL file) throws Exception {
        if (file == null) {
            return Collections.emptyList();
        }
        InputStream stream = file.openStream();
        PNMLFormat format = new PNMLFormat();
        List<Drawing> result = format.parse(stream);
        stream.close();
        return result;
    }

    public List<Drawing> importFile(String src) throws Exception {
        if (src == null || src == "") {
            return Collections.emptyList();
        }
        PNMLFormat format = new PNMLFormat();
        return format.parse(new ByteArrayInputStream(src.getBytes()));
    }
}

