/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.tool;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CreationTool;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.VirtualTransitionFigure;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class VirtualTransitionFigureCreationTool
extends CreationTool {
    private VirtualTransitionFigure virtualTransition = null;

    public VirtualTransitionFigureCreationTool(DrawingEditor editor) {
        super(editor);
    }

    protected Figure createFigure() {
        return new VirtualTransitionFigure(null);
    }

    public void mouseMove(MouseEvent e, int x, int y) {
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        Figure fTarget = this.drawing().findFigure(x, y);
        if (fTarget instanceof TransitionFigure) {
            TransitionFigure semanticTransitionFigure = (TransitionFigure)fTarget;
            while (semanticTransitionFigure instanceof VirtualTransitionFigure) {
                VirtualTransitionFigure virtualTransitionFigure = (VirtualTransitionFigure)semanticTransitionFigure;
                semanticTransitionFigure = virtualTransitionFigure.getSemanticFigure();
            }
            this.virtualTransition = new VirtualTransitionFigure(semanticTransitionFigure);
            this.view().add((Figure)this.virtualTransition);
            FigureEnumeration children = ((TransitionFigure)fTarget).children();
            Rectangle r = fTarget.displayBox();
            while (children.hasMoreElements()) {
                CPNTextFigure textFig;
                Figure nextFigure = children.nextFigure();
                if (!(nextFigure instanceof CPNTextFigure) || (textFig = (CPNTextFigure)nextFigure).getType() != 2) continue;
                CPNTextFigure virtualTransitionName = new CPNTextFigure(2);
                virtualTransitionName.setText(textFig.getText());
                this.view().add((Figure)virtualTransitionName);
                virtualTransitionName.setParent(this.virtualTransition);
                int xDistance = textFig.displayBox().x - r.x;
                int yDistance = textFig.displayBox().y - r.y;
                virtualTransitionName.moveBy(xDistance, yDistance);
            }
            this.virtualTransition.displayBox(new Rectangle(r.x, r.y, r.width, r.height));
            this.changesMade();
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        if (this.virtualTransition != null) {
            Rectangle r = this.virtualTransition.displayBox();
            this.virtualTransition.displayBox(new Rectangle(x - r.width / 2, y - r.height / 2, r.width, r.height));
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        this.virtualTransition = null;
        this.editor().toolDone();
    }

    public void deactivate() {
        super.deactivate();
        this.virtualTransition = null;
    }
}

