/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.tool;

import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.SelectionTool;
import CH.ifa.draw.util.ColorMap;
import de.renew.application.Util;
import de.renew.gui.GuiPlugin;
import de.renew.gui.InscribableFigure;
import de.renew.gui.TextFigureCreator;
import de.renew.net.NetInstance;
import java.awt.Point;
import java.net.URI;

public class CPNSelectionTool
extends SelectionTool {
    public CPNSelectionTool(DrawingEditor application) {
        super(application);
    }

    protected boolean alternateInspectFigure(Figure f) {
        if (f instanceof InscribableFigure) {
            InscribableFigure inf = (InscribableFigure)f;
            this.editor().prepareUndoSnapshot();
            if (inf instanceof LineConnection && inf.children().hasMoreElements()) {
                inf.children().nextFigure().inspect(this.view(), true);
                return true;
            }
            TextFigureCreator tfc = GuiPlugin.getCurrent().getTextFigureCreator();
            TextFigure child = tfc.createTextFigure(inf);
            child.setParent((ParentFigure)inf);
            Point p = this.view().lastClick();
            child.displayBox(p, new Point(p.x + 10, p.y + 10));
            if (child.getText().isEmpty()) {
                child.setText(tfc.getDefaultInscription(inf));
            }
            child.setAttribute("TextType", (Object)1);
            if (inf instanceof LineConnection) {
                child.setAttribute("FillColor", (Object)ColorMap.BACKGROUND);
            }
            this.drawing().add((Figure)child);
            this.view().clearSelection();
            this.view().addToSelection((Figure)child);
            this.editor().commitUndoSnapshot();
            return true;
        }
        return super.alternateInspectFigure(f);
    }

    public void simAccess(URI uri) {
        Util util = new Util();
        NetInstance instance = util.findInstance("" + uri.getPort());
        if (instance == null) {
            return;
        }
        util.fireTransition(instance, uri.getPath());
    }
}

