/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.framework.ParentFigure;
import de.renew.gui.pnml.converter.NetConverter;
import de.renew.gui.pnml.parser.AnnotationParser;
import de.renew.gui.pnml.parser.AttributeParser;
import de.renew.gui.pnml.parser.ElementParser;
import de.renew.gui.pnml.parser.GraphicParser;
import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ObjectParser
extends ElementParser {
    private static final Logger logger = Logger.getLogger(ObjectParser.class);
    private static final Pattern NUMERIC_ID_PATTERN = Pattern.compile("\\d+");
    private FigureWithID _figure;
    private String _pnmlId;
    private Integer _mappedId = null;
    private final List<AnnotationParser> _annotation = new LinkedList<AnnotationParser>();
    private final List<AttributeParser> _attributes = new LinkedList<AttributeParser>();
    private int _posAnnotation = 0;
    private boolean _isParsed = false;
    private GraphicParser _parser;

    public ObjectParser(Element object, NetConverter converter) {
        super(object, converter);
    }

    protected FigureWithID figure() {
        return this._figure;
    }

    protected String getPNMLId() {
        return this._pnmlId;
    }

    public Integer getMappedId() {
        return this._mappedId;
    }

    public void setMappedId(Integer value) {
        this._mappedId = value;
    }

    protected List<AttributeParser> getAttributes() {
        return this._attributes;
    }

    protected GraphicParser getGraphic() {
        return this._parser;
    }

    public boolean hasNumericId() {
        return this._mappedId != null;
    }

    private void parseId() {
        this._pnmlId = this.getElement().getAttribute("id");
        try {
            this._mappedId = ObjectParser.parseNumericId(this._pnmlId);
        }
        catch (NumberFormatException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected static int parseNumericId(String stringValue) throws NumberFormatException {
        Matcher matcher = NUMERIC_ID_PATTERN.matcher(stringValue);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group());
        }
        throw new NumberFormatException("No digits found in PNML ID string: \"" + stringValue + "\"");
    }

    private void parseGraphics() {
        NodeList children = this.getElement().getChildNodes();
        Element element = null;
        for (int pos = 0; pos < children.getLength(); ++pos) {
            Node child = children.item(pos);
            if (!"graphics".equals(child.getNodeName())) continue;
            element = (Element)child;
            break;
        }
        GraphicParser parser = new GraphicParser(element, this.getNetConverter());
        parser.parse();
        this._parser = parser;
    }

    private boolean isVirtual(Element anno) {
        NodeList tools = anno.getElementsByTagName("toolspecific");
        for (int pos = 0; pos < tools.getLength(); ++pos) {
            Element ele = (Element)tools.item(pos);
            if (!"renew".equals(ele.getAttribute("tool")) || ele.getElementsByTagName("virtual").getLength() == 0) continue;
            return true;
        }
        return false;
    }

    private void parseLabels() {
        NodeList children = this.getElement().getChildNodes();
        for (int pos = 0; pos < children.getLength(); ++pos) {
            Node child = children.item(pos);
            if (child.getNodeType() != 1) continue;
            Element childEle = (Element)child;
            if ("toolspecific".equals(childEle.getTagName()) && "renew".equals(childEle.getAttribute("tool"))) {
                NodeList inscs = childEle.getElementsByTagName("inscription");
                for (int i = 0; i < inscs.getLength(); ++i) {
                    this.parseSingleLabel((Element)inscs.item(i));
                }
                continue;
            }
            this.parseSingleLabel(childEle);
        }
    }

    private void parseSingleLabel(Element label) {
        NetConverter con = this.getNetConverter();
        if (con.isAnnotation(label) || con.isInRenewAnnotation(label)) {
            if (!this.isVirtual(label)) {
                AnnotationParser parser = new AnnotationParser(label, con);
                parser.parse();
                this._annotation.add(parser);
            }
        } else if (con.isAttribute(label)) {
            AttributeParser parser = new AttributeParser(label, con);
            parser.parse();
            this._attributes.add(parser);
        }
    }

    protected void parseFigure() {
    }

    @Override
    protected void doParse() {
        this.parseId();
        this.parseGraphics();
        this.parseLabels();
        this.parseFigure();
        this._isParsed = true;
    }

    protected abstract FigureWithID createObject();

    protected abstract void initGraphic();

    protected void doInitFigure() {
        this.initGraphic();
    }

    public FigureWithID getFigure() {
        if (!this._isParsed) {
            this.parse();
        }
        this._figure = this.createObject();
        this._figure.setID(this._mappedId.intValue());
        this.doInitFigure();
        return this._figure;
    }

    public boolean hasMoreAnnotations() {
        return this._annotation.size() > this._posAnnotation;
    }

    public TextFigure nextAnnotation() {
        AnnotationParser parser = this._annotation.get(this._posAnnotation);
        TextFigure result = parser.getFigure();
        if (result != null) {
            Point point = result.displayBox().getLocation();
            result.setParent((ParentFigure)this._figure);
            if (point.x != 0 || point.y != 0) {
                result.moveBy(point.x, point.y);
            }
        }
        ++this._posAnnotation;
        return result;
    }

    protected void moveObject(int x, int y) {
        this._figure.moveBy(x, y);
    }
}

