/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.pnml.converter.Converter;
import de.renew.gui.pnml.parser.AnnotationParser;
import de.renew.gui.pnml.parser.ArcParser;
import de.renew.gui.pnml.parser.ElementParser;
import de.renew.gui.pnml.parser.ObjectParser;
import de.renew.gui.pnml.parser.PlaceParser;
import de.renew.gui.pnml.parser.TransitionParser;
import de.renew.gui.pnml.parser.VirtualPlaceParser;
import de.renew.gui.pnml.parser.VirtualTransitionParser;
import java.awt.Point;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NetParser
extends ElementParser {
    private int _maxId = 0;
    private final Hashtable<String, Integer> _mapping = new Hashtable();
    private Drawing _net;

    public NetParser(Element element) {
        super(element, null);
    }

    private void trySetMaxId(Integer id) {
        int value = id;
        if (this._maxId < value) {
            this._maxId = value;
        }
    }

    public Drawing getNet() {
        return this._net;
    }

    private void makeOffset() {
        Figure element;
        int offsetX = 0;
        int offsetY = 0;
        FigureEnumeration elements = this._net.figures();
        while (elements.hasMoreElements()) {
            element = (Figure)elements.nextElement();
            Point pos = element.center();
            if (pos.x < offsetX) {
                offsetX = pos.x - element.size().width / 2;
            }
            if (pos.y >= offsetY) continue;
            offsetY = pos.y - element.size().height / 2;
        }
        if (offsetX < 0 || offsetY < 0) {
            elements = this._net.figures();
            offsetX *= -1;
            offsetY *= -1;
            while (elements.hasMoreElements()) {
                element = (Figure)elements.nextElement();
                if (element instanceof ChildFigure) {
                    ChildFigure childFigure = (ChildFigure)element;
                    if (childFigure.parent() != null) continue;
                    element.moveBy(offsetX, offsetY);
                    continue;
                }
                element.moveBy(offsetX, offsetY);
            }
        }
    }

    private void addAnnotations(ObjectParser parser) {
        while (parser.hasMoreAnnotations()) {
            TextFigure annotation = parser.nextAnnotation();
            if (annotation == null) continue;
            ++this._maxId;
            annotation.setID(this._maxId);
            this._net.add((Figure)annotation);
        }
    }

    private void work(Iterator<ObjectParser> parsers) {
        while (parsers.hasNext()) {
            ObjectParser objectParser = parsers.next();
            if (!objectParser.hasNumericId()) {
                ++this._maxId;
                objectParser.setMappedId(this._maxId);
                this._mapping.put(objectParser.getPNMLId(), this._maxId);
            }
            this._net.add((Figure)objectParser.getFigure());
            this.addAnnotations(objectParser);
        }
    }

    @Override
    public void doParse() {
        int pos;
        this._net = new CPNDrawing();
        String netType = this.getElement().getAttribute("type");
        Converter converter = new Converter(netType);
        this.setNetConverter(converter.getNetConverter());
        LinkedList<PlaceParser> placeParsers = new LinkedList<PlaceParser>();
        LinkedList<TransitionParser> transitionParsers = new LinkedList<TransitionParser>();
        LinkedList<ArcParser> arcParsers = new LinkedList<ArcParser>();
        LinkedList<VirtualPlaceParser> virPlaceParsers = new LinkedList<VirtualPlaceParser>();
        LinkedList<VirtualTransitionParser> virTransitionParsers = new LinkedList<VirtualTransitionParser>();
        NodeList places = this.getElement().getElementsByTagName("place");
        NodeList transitions = this.getElement().getElementsByTagName("transition");
        NodeList arcs = this.getElement().getElementsByTagName("arc");
        NodeList toolspecifics = this.getElement().getElementsByTagName("toolspecific");
        for (pos = 0; pos < places.getLength(); ++pos) {
            Element place = (Element)places.item(pos);
            PlaceParser placeParser = new PlaceParser(place, this.getNetConverter());
            placeParsers.add(placeParser);
            placeParser.parse();
            if (!placeParser.hasNumericId()) continue;
            this.trySetMaxId(placeParser.getMappedId());
        }
        for (pos = 0; pos < transitions.getLength(); ++pos) {
            Element transition = (Element)transitions.item(pos);
            TransitionParser transitionParser = new TransitionParser(transition, this.getNetConverter());
            transitionParsers.add(transitionParser);
            transitionParser.parse();
            if (!transitionParser.hasNumericId()) continue;
            this.trySetMaxId(transitionParser.getMappedId());
        }
        for (pos = 0; pos < arcs.getLength(); ++pos) {
            Element arc = (Element)arcs.item(pos);
            ArcParser arcParser = new ArcParser(arc, this._mapping, this._net, this.getNetConverter());
            arcParsers.add(arcParser);
            arcParser.parse();
            if (!arcParser.hasNumericId()) continue;
            this.trySetMaxId(arcParser.getMappedId());
        }
        for (pos = 0; pos < toolspecifics.getLength(); ++pos) {
            NodeList decls;
            Element toolspecific = (Element)toolspecifics.item(pos);
            if (!toolspecific.getAttribute("tool").equals("renew")) continue;
            NodeList virPlaces = toolspecific.getElementsByTagName("VirtualPlace");
            NodeList virTransitions = toolspecific.getElementsByTagName("VirtualTransition");
            if (virPlaces.getLength() > 0) {
                Element virPlace = (Element)virPlaces.item(0);
                VirtualPlaceParser virPlaceParser = new VirtualPlaceParser(virPlace, this._net, this.getNetConverter());
                virPlaceParsers.add(virPlaceParser);
                virPlaceParser.parse();
                if (virPlaceParser.hasNumericId()) {
                    this.trySetMaxId(virPlaceParser.getMappedId());
                }
            }
            if (virTransitions.getLength() > 0) {
                Element virTransition = (Element)virTransitions.item(0);
                VirtualTransitionParser virTransitionParser = new VirtualTransitionParser(virTransition, this._net, this.getNetConverter());
                virTransitionParsers.add(virTransitionParser);
                virTransitionParser.parse();
                if (virTransitionParser.hasNumericId()) {
                    this.trySetMaxId(virTransitionParser.getMappedId());
                }
            }
            if ((decls = toolspecific.getElementsByTagName("declaration")).getLength() <= 0) continue;
            Element declaration = (Element)decls.item(0);
            AnnotationParser declParser = new AnnotationParser(declaration, this.getNetConverter());
            declParser.parse();
            TextFigure fig = declParser.getFigure();
            if (fig == null) continue;
            this._net.add((Figure)fig);
        }
        NodeList children = this.getElement().getChildNodes();
        for (int pos2 = 0; pos2 < children.getLength(); ++pos2) {
            CPNTextFigure anno;
            Node child = children.item(pos2);
            if (child.getNodeType() != 1) continue;
            Element element = (Element)child;
            if (!this.getNetConverter().isAnnotation(element)) continue;
            AnnotationParser annotationParser = new AnnotationParser((Element)child, this.getNetConverter());
            annotationParser.parse();
            TextFigure figure = annotationParser.getFigure();
            ++this._maxId;
            if (figure == null) continue;
            figure.setID(this._maxId);
            if (figure instanceof CPNTextFigure && (anno = (CPNTextFigure)figure).getType() == 2) {
                this._net.setName(anno.getText());
                continue;
            }
            this._net.add((Figure)figure);
        }
        Iterator<ObjectParser> parsers = placeParsers.iterator();
        this.work(parsers);
        parsers = virPlaceParsers.iterator();
        this.work(parsers);
        parsers = transitionParsers.iterator();
        this.work(parsers);
        parsers = virTransitionParsers.iterator();
        this.work(parsers);
        parsers = arcParsers.iterator();
        this.work(parsers);
        this.makeOffset();
    }
}

