/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureWithID;
import de.renew.gui.ArcConnection;
import de.renew.gui.DoubleArcConnection;
import de.renew.gui.HollowDoubleArcConnection;
import de.renew.gui.InhibitorConnection;
import de.renew.gui.pnml.converter.NetConverter;
import de.renew.gui.pnml.parser.AttributeParser;
import de.renew.gui.pnml.parser.ObjectParser;
import java.awt.Color;
import java.awt.Point;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ArcParser
extends ObjectParser {
    private final Map<String, Integer> _keys;
    private String _sourceString;
    private String _targetString;
    private final Drawing _net;

    public ArcParser(Element arc, Map<String, Integer> keys, Drawing net, NetConverter converter) {
        super(arc, converter);
        this._keys = keys;
        this._net = net;
    }

    @Override
    protected FigureWithID createObject() {
        ArcConnection result = new ArcConnection(1);
        for (AttributeParser parser : this.getAttributes()) {
            if (!parser.attributeName().equals("ArcType")) continue;
            String type = parser.attributeValue();
            if (type.equals("inhibitor")) {
                result = new InhibitorConnection();
                continue;
            }
            if (type.equals("multi-ordinary")) {
                result = new DoubleArcConnection();
                continue;
            }
            if (type.equals("clear")) {
                result = new HollowDoubleArcConnection();
                continue;
            }
            if (type.equals("both")) {
                result = new ArcConnection(2);
                continue;
            }
            if (!type.equals("test")) continue;
            result = new ArcConnection(0);
        }
        result.startPoint(0, 0);
        result.endPoint(0, 0);
        return result;
    }

    @Override
    protected void parseFigure() {
        String source = this.getElement().getAttribute("source");
        String target = this.getElement().getAttribute("target");
        NodeList toolSpecs = this.getElement().getElementsByTagName("toolspecific");
        if (toolSpecs.getLength() > 0) {
            for (int pos = 0; pos < toolSpecs.getLength(); ++pos) {
                Element toolSpec = (Element)toolSpecs.item(pos);
                if (!"renew".equals(toolSpec.getAttribute("tool"))) continue;
                if (toolSpec.hasAttribute("source")) {
                    source = toolSpec.getAttribute("source");
                }
                if (!toolSpec.hasAttribute("target")) continue;
                target = toolSpec.getAttribute("target");
            }
        }
        this._sourceString = source;
        this._targetString = target;
    }

    private Connector findConnector(Drawing net, int id) {
        FigureEnumeration figures = net.figures();
        while (figures.hasMoreElements()) {
            FigureWithID figure;
            Figure element = (Figure)figures.nextElement();
            if (!(element instanceof FigureWithID) || (figure = (FigureWithID)element).getID() != id) continue;
            Point center = figure.center();
            return figure.connectorAt(center.x, center.y);
        }
        return null;
    }

    @Override
    protected void doInitFigure() {
        int target;
        int source;
        ArcConnection arc = (ArcConnection)this.figure();
        if (this._keys.containsKey(this._sourceString)) {
            source = this._keys.get(this._sourceString);
        } else {
            try {
                source = ArcParser.parseNumericId(this._sourceString);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Could not find PNML arc source with ID \"" + this._sourceString + "\"");
            }
        }
        if (this._keys.containsKey(this._targetString)) {
            target = this._keys.get(this._targetString);
        } else {
            try {
                target = ArcParser.parseNumericId(this._targetString);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Could not find PNML arc target with ID \"" + this._targetString + "\"");
            }
        }
        arc.connectStart(this.findConnector(this._net, source));
        arc.connectEnd(this.findConnector(this._net, target));
        arc.updateConnection();
        super.doInitFigure();
    }

    @Override
    protected void initGraphic() {
        ArcConnection arc = (ArcConnection)this.figure();
        int pos = 1;
        Iterator<Point> positionen = this.getGraphic().positions();
        while (positionen.hasNext()) {
            Point element = positionen.next();
            arc.insertPointAt(element, pos++);
        }
        Color lineColor = this.getGraphic().getLineColor();
        String lineStyle = this.getGraphic().getLineStyle();
        if (lineColor != null) {
            this.figure().setAttribute("FrameColor", (Object)lineColor);
        }
        if (lineStyle != null) {
            this.figure().setAttribute("LineStyle", (Object)lineStyle);
        }
    }
}

