/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.nin;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.ChildFigure;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.InscribableFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import java.awt.Dimension;
import java.awt.Point;

public class TemplateBuilder {
    private static final Point[] elementPositions = new Point[]{new Point(200, 100), new Point(100, 100), new Point(100, 200), new Point(100, 300), new Point(200, 300)};
    private static final String[] inscriptions = new String[]{"[]", "netA:new NetA;\nnetB:new NetB", "", "NetReferences", "netA;netB", ":getReference(net)", "net", "this:getReference(netA);\nthis:getReference(netB);\nnetA:sync();\nnetB:sync()"};

    public static CPNDrawing buildSystemNetTemplate() {
        CPNDrawing systemNet = new CPNDrawing();
        PlaceFigure initiallyMarkedPlace = TemplateBuilder.buildPlace(systemNet, inscriptions[0], CPNTextFigure.STYLE[2], 1, elementPositions[0], 0, 0);
        TransitionFigure netCreationTransition = TemplateBuilder.buildTransition(systemNet, inscriptions[1], elementPositions[1], 0, -25);
        TemplateBuilder.buildArc(initiallyMarkedPlace, netCreationTransition, 1, inscriptions[2], systemNet, 0, 0);
        PlaceFigure referenceHolder = TemplateBuilder.buildPlace(systemNet, inscriptions[3], CPNTextFigure.STYLE[0], 2, elementPositions[2], 65, 0);
        TemplateBuilder.buildArc(netCreationTransition, referenceHolder, 1, inscriptions[4], systemNet, 0, 0);
        TransitionFigure getReferenceTransition = TemplateBuilder.buildTransition(systemNet, inscriptions[5], elementPositions[3], 0, 20);
        TemplateBuilder.buildArc(referenceHolder, getReferenceTransition, 0, inscriptions[6], systemNet, 0, 0);
        TemplateBuilder.buildTransition(systemNet, inscriptions[7], elementPositions[4], 75, -20);
        return systemNet;
    }

    private static PlaceFigure buildPlace(CPNDrawing systemNet, String inscription, int style, int inscriptionType, Point position, int moveInscriptionX, int moveInscriptionY) {
        PlaceFigure place = new PlaceFigure();
        systemNet.add(place);
        TemplateBuilder.setFigurePosition((AttributeFigure)place, position);
        CPNTextFigure inscriptionText = new CPNTextFigure(inscriptionType);
        inscriptionText.setText(inscription);
        inscriptionText.setAttribute("TextType", style);
        TemplateBuilder.addChildText(place, inscriptionText, systemNet, moveInscriptionX, moveInscriptionY);
        return place;
    }

    private static TransitionFigure buildTransition(CPNDrawing systemNet, String inscription, Point position, int moveInscriptionX, int moveInscriptionY) {
        TransitionFigure transition = new TransitionFigure();
        systemNet.add(transition);
        TemplateBuilder.setFigurePosition((AttributeFigure)transition, position);
        CPNTextFigure inscriptionText = new CPNTextFigure(1);
        inscriptionText.setText(inscription);
        TemplateBuilder.addChildText(transition, inscriptionText, systemNet, moveInscriptionX, moveInscriptionY);
        return transition;
    }

    private static void buildArc(InscribableFigure outgoing, InscribableFigure incoming, int arcType, String inscription, CPNDrawing systemNet, int moveInscriptionX, int moveInscriptionY) {
        ArcConnection addedArc = new ArcConnection(arcType);
        addedArc.startPoint(outgoing.center());
        addedArc.endPoint(incoming.center());
        systemNet.add(addedArc);
        addedArc.connectStart(outgoing.connectorAt(outgoing.center()));
        addedArc.connectEnd(incoming.connectorAt(incoming.center()));
        if (!inscription.isBlank()) {
            CPNTextFigure creationText = new CPNTextFigure(1);
            creationText.setText(inscription);
            TemplateBuilder.addChildText(addedArc, creationText, systemNet, moveInscriptionX, moveInscriptionY);
        }
        addedArc.updateConnection();
    }

    private static void setFigurePosition(AttributeFigure figure, Point position) {
        Dimension d = figure instanceof PlaceFigure ? PlaceFigure.defaultDimension() : TransitionFigure.defaultDimension();
        int w2 = d.width / 2;
        int h2 = d.height / 2;
        figure.displayBox(new Point(position.x - w2, position.y - h2), new Point(position.x - w2 + d.width, position.y - h2 + d.height));
    }

    private static void addChildText(InscribableFigure parent, CPNTextFigure child, CPNDrawing systemNet, int moveX, int moveY) {
        systemNet.add(child);
        parent.addChild((ChildFigure)child);
        child.setParent(parent);
        child.moveBy(moveX, moveY);
    }
}

