/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.configure;

import CH.ifa.draw.DrawPlugin;
import de.renew.gui.CPNApplication;
import de.renew.gui.configure.RemoteServerWindow;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.RemoteServerRegistry;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class RemoteServerController {
    private static final Logger logger = Logger.getLogger(RemoteServerController.class);
    private final CPNApplication _editor;
    private final RemoteServerWindow _gui;

    public RemoteServerController(CPNApplication editor) {
        this._editor = editor;
        this._gui = new RemoteServerWindow();
        this._gui.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().removeFrame((Frame)RemoteServerController.this._gui);
            }
        });
        this._gui.addDisconnectListener(e -> this.doDisconnect());
        this._gui.addConnectListener(e -> this.doConnect());
        this._gui.addServerSelectedListener(e -> this.doSelectServer());
        this._gui.addOpenNetInstanceListener(this::openNetInstance);
    }

    public void show() {
        this.updateView();
        this._gui.setVisible(true);
        this._gui.setState(0);
        this._gui.toFront();
        DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().addFrame("Tools", (Frame)this._gui);
    }

    public void doSelectServer() {
        this.updateView();
    }

    public void doConnect() {
        String name = this._gui.getDialogName();
        String host = this._gui.getDialogServer();
        RemoteServerRegistry.ServerDescriptor server = null;
        try {
            if (!"".equals(name) && !"".equals(host)) {
                server = RemoteServerRegistry.instance().connectServer(host, name);
            }
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
            JOptionPane.showMessageDialog(this._gui, "An error occurred while connecting to remote server.\nReason:\n" + String.valueOf(e) + "\nTry setting the property de.renew.remote.rmi-host-name to\nthe network-address you want to use.", "RMI-Problem", 0);
        }
        this._gui.disposeDialog();
        if (server != null) {
            this.updateView();
            this._gui.selectServer(server);
        }
        this.updateView();
    }

    public void doDisconnect() {
        int index = this._gui.getSelectedServerIndex();
        if (index >= 1) {
            RemoteServerRegistry.instance().removeServer(index - 1);
            this.updateView();
        }
    }

    public void openNetInstance() {
        int index = this._gui.getSelectedNetInstanceIndex();
        if (index >= 0) {
            Object netObj = this._gui.getNetInstanceModelByIndex(index);
            NetInstanceAccessor net = null;
            if (netObj instanceof NetInstanceAccessor) {
                NetInstanceAccessor netInstanceAccessor;
                net = netInstanceAccessor = (NetInstanceAccessor)netObj;
            } else if (netObj instanceof RemoteServerWindow.WeakNetInstanceWrapper) {
                RemoteServerWindow.WeakNetInstanceWrapper wrapper = (RemoteServerWindow.WeakNetInstanceWrapper)netObj;
                net = wrapper.getInstance();
                if (net == null) {
                    logger.debug((Object)"Refreshing net list due to null reference...");
                    this.updateView();
                }
            } else assert (false) : "Unexpected object type in net instance list: " + String.valueOf(netObj.getClass());
            if (net != null) {
                this._editor.openInstanceDrawing(net);
            }
        }
    }

    private void updateView() {
        try {
            this._gui.updateView();
        }
        catch (RemoteException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
            JOptionPane.showMessageDialog(this._gui, "An error occurred while calling remote objects.\nReason:\n" + String.valueOf(e), "RMI-Problem", 0);
        }
    }
}

