/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.configure;

import de.renew.util.PathEntry;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

class EditPathEntryDialog
extends JDialog {
    private boolean commit = false;
    private JCheckBox useClasspathBox;
    private JButton okButton;
    private JTextField pathField;

    EditPathEntryDialog(JDialog parent, String okText) {
        super(parent, okText + " path entry", true);
        this.initComponents();
        if (okText != null) {
            this.okButton.setText(okText);
        }
        this.pack();
    }

    private void initComponents() {
        this.pathField = new JTextField();
        this.useClasspathBox = new JCheckBox();
        this.okButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditPathEntryDialog.this.cancelDialog();
            }
        });
        JLabel pathLabel = new JLabel();
        pathLabel.setText("Path:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)pathLabel, gridBagConstraints);
        this.pathField.setText("/this/is/a/rather/long/path/name/for/unix/systems/with/slashes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.pathField, gridBagConstraints);
        this.useClasspathBox.setText("relative to classpath");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.useClasspathBox, gridBagConstraints);
        this.okButton.setText("OK");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.okButton.addActionListener(e -> this.commitDialog());
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        JButton cancelButton = new JButton();
        cancelButton.setText("Cancel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        cancelButton.addActionListener(e -> this.cancelDialog());
        this.getContentPane().add((Component)cancelButton, gridBagConstraints);
    }

    private void commitDialog() {
        this.commit = true;
        this.setVisible(false);
        this.dispose();
    }

    private void cancelDialog() {
        this.commit = false;
        this.setVisible(false);
        this.dispose();
    }

    boolean isCommitted() {
        return this.commit;
    }

    PathEntry getEntry() {
        return new PathEntry(this.pathField.getText(), this.useClasspathBox.isSelected());
    }

    void setEntry(PathEntry entry) {
        this.useClasspathBox.setSelected(entry.isClasspathRelative);
        this.pathField.setText(entry.path);
    }
}

