/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.MergedFigureEnumerator;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.gui.TransitionFigure;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class VirtualTransitionFigure
extends TransitionFigure {
    private TransitionFigure transition = null;

    public VirtualTransitionFigure() {
    }

    public VirtualTransitionFigure(TransitionFigure transition) {
        this.setTransition(transition);
    }

    private void setTransition(TransitionFigure transition) {
        this.transition = (TransitionFigure)transition.getSemanticFigure();
        this.adapt();
        final FigureChangeEvent removeEvent = new FigureChangeEvent((Figure)this, null);
        transition.addFigureChangeListener((FigureChangeListener)new FigureChangeAdapter(){

            public void figureChanged(FigureChangeEvent e) {
                VirtualTransitionFigure.this.adapt();
            }

            public void figureRemoved(FigureChangeEvent e) {
                if (VirtualTransitionFigure.this.listener() != null) {
                    VirtualTransitionFigure.this.listener().figureRequestRemove(removeEvent);
                }
            }
        });
    }

    @Override
    public TransitionFigure getSemanticFigure() {
        return (TransitionFigure)this.transition.getSemanticFigure();
    }

    private void adapt() {
        super.setAttribute("FillColor", (Object)this.transition.getFillColor());
        super.setAttribute("FrameColor", (Object)this.transition.getFrameColor());
    }

    public void drawFrame(Graphics g) {
        super.drawFrame(g);
        Rectangle r = this.displayBox();
        Rectangle2D.Float s = new Rectangle2D.Float(r.x + 2, r.y + 2, r.width - 4, r.height - 4);
        ((Graphics2D)g).draw(s);
    }

    @Override
    public ShadowNetElement buildShadow(ShadowNet net) {
        return null;
    }

    @Override
    public ShadowNetElement getShadow() {
        return this.transition.getShadow();
    }

    public void setAttribute(String attr, Object value) {
        if ("FillColor".equals(attr) || "FrameColor".equals(attr)) {
            this.transition.setAttribute(attr, value);
        } else {
            super.setAttribute(attr, value);
        }
    }

    public boolean inspect(DrawingView view, boolean alternate) {
        if (alternate) {
            return super.inspect(view, true);
        }
        view.clearSelection();
        view.addToSelection((Figure)this.transition);
        return true;
    }

    @Override
    public FigureEnumeration getFiguresWithDependencies() {
        FigureEnumeration superDep = super.getFiguresWithDependencies();
        Vector<TransitionFigure> myDep = new Vector<TransitionFigure>(1);
        myDep.addElement(this.transition);
        return new MergedFigureEnumerator(superDep, (FigureEnumeration)new FigureEnumerator(myDep));
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable((Storable)this.transition);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.setTransition((TransitionFigure)dr.readStorable());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setTransition(this.transition);
    }
}

