/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.MergedFigureEnumerator;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.gui.PlaceFigure;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class VirtualPlaceFigure
extends PlaceFigure {
    private static final long serialVersionUID = -7877776241236946511L;
    private final int virtualPlaceFigureSerializedDataVersion = 1;
    private PlaceFigure place = null;

    public VirtualPlaceFigure() {
    }

    public VirtualPlaceFigure(PlaceFigure place) {
        this.setPlace(place);
    }

    private void setPlace(PlaceFigure place) {
        this.place = (PlaceFigure)place.getSemanticFigure();
        this.adapt();
        final FigureChangeEvent removeEvent = new FigureChangeEvent((Figure)this, null);
        place.addFigureChangeListener((FigureChangeListener)new FigureChangeAdapter(){

            public void figureChanged(FigureChangeEvent e) {
                VirtualPlaceFigure.this.adapt();
            }

            public void figureRemoved(FigureChangeEvent e) {
                if (VirtualPlaceFigure.this.listener() != null) {
                    VirtualPlaceFigure.this.listener().figureRequestRemove(removeEvent);
                }
            }
        });
    }

    @Override
    public PlaceFigure getSemanticFigure() {
        return (PlaceFigure)this.place.getSemanticFigure();
    }

    private void adapt() {
        super.setAttribute("FillColor", (Object)this.place.getFillColor());
        super.setAttribute("FrameColor", (Object)this.place.getFrameColor());
    }

    public void drawFrame(Graphics g) {
        super.drawFrame(g);
        Rectangle r = this.displayBox();
        Ellipse2D.Double s = new Ellipse2D.Double(r.x + 2, r.y + 2, r.width - 4, r.height - 4);
        ((Graphics2D)g).draw(s);
    }

    @Override
    public ShadowNetElement buildShadow(ShadowNet net) {
        return null;
    }

    @Override
    public ShadowNetElement getShadow() {
        return this.place.getShadow();
    }

    public void setAttribute(String attr, Object value) {
        if ("FillColor".equals(attr) || "FrameColor".equals(attr)) {
            this.place.setAttribute(attr, value);
        } else {
            super.setAttribute(attr, value);
        }
    }

    public boolean inspect(DrawingView view, boolean alternate) {
        if (alternate) {
            return super.inspect(view, true);
        }
        view.clearSelection();
        view.addToSelection((Figure)this.place);
        return true;
    }

    @Override
    public FigureEnumeration getFiguresWithDependencies() {
        FigureEnumeration superDep = super.getFiguresWithDependencies();
        Vector<PlaceFigure> myDep = new Vector<PlaceFigure>(1);
        myDep.addElement(this.place);
        return new MergedFigureEnumerator(superDep, (FigureEnumeration)new FigureEnumerator(myDep));
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable((Storable)this.place);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.setPlace((PlaceFigure)dr.readStorable());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setPlace(this.place);
    }
}

