/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import de.renew.gui.BindingSelectionFrame;
import de.renew.gui.CPNSimulation;
import de.renew.gui.InstanceDrawing;
import de.renew.gui.InstanceFigure;
import de.renew.gui.ModeReplacement;
import de.renew.gui.TransitionFigure;
import de.renew.remote.EventListener;
import de.renew.remote.ObjectAccessor;
import de.renew.remote.RemoteEventForwarder;
import de.renew.remote.RemoteEventListener;
import de.renew.remote.TransitionInstanceAccessor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class TransitionInstanceFigure
extends AbstractFigure
implements InstanceFigure,
EventListener {
    private static final Logger logger = Logger.getLogger(TransitionInstanceFigure.class);
    private final TransitionFigure transitionFigure;
    private TransitionInstanceAccessor transitionInstance;
    private boolean afterglow = false;
    private RemoteEventForwarder forwarder;
    protected final InstanceDrawing drawing;
    private static final int AFTERGLOW_TIME = 100;
    private static final int COOLDOWN_TIME = 10;
    private final Runnable afterglowRunnable;
    private final ThreadPoolExecutor executor;

    public TransitionInstanceFigure(InstanceDrawing drawing, TransitionFigure tf, Hashtable<Serializable, ObjectAccessor> netElements) {
        this.drawing = drawing;
        this.transitionFigure = tf;
        this.afterglowRunnable = () -> {
            try {
                EventQueue.invokeAndWait(() -> this.updateAfterglow(true));
                do {
                    Thread.sleep(100L);
                } while (this.isFiring());
                EventQueue.invokeAndWait(() -> this.updateAfterglow(false));
                Thread.sleep(10L);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        };
        this.executor = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.DiscardPolicy());
        this.initialize(netElements);
        if (this.isFiring()) {
            this.update();
        }
    }

    private void updateAfterglow(boolean newValue) {
        if (this.afterglow != newValue) {
            this.afterglow = newValue;
            if (this.listener() != null) {
                this.invalidate();
                this.invalidateHighlight();
                FigureChangeEvent event = new FigureChangeEvent((Figure)this);
                this.listener().figureRequestUpdate(event);
            }
        }
    }

    protected void initialize(Hashtable<Serializable, ObjectAccessor> netElements) {
        if (netElements.size() != 1) {
            logger.error((Object)("Error: There is not exactly one transition instance for the figure " + String.valueOf(this)));
            return;
        }
        this.transitionInstance = (TransitionInstanceAccessor)netElements.elements().nextElement();
        try {
            this.forwarder = new RemoteEventForwarder((EventListener)this);
            this.transitionInstance.addRemoteEventListener((RemoteEventListener)this.forwarder);
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean isFiring() {
        boolean result = false;
        try {
            if (this.transitionInstance != null) {
                result = this.transitionInstance.isFiring();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public boolean isHighlighted() {
        return this.afterglow;
    }

    private void invalidateHighlight() {
        Figure highlight = this.transitionFigure.getHighlightFigure();
        if (highlight != null) {
            Rectangle area = highlight.displayBox();
            DrawingChangeEvent dce = new DrawingChangeEvent((Drawing)this.drawing, area);
            this.drawing.drawingInvalidated(dce);
        }
    }

    public void update() {
        this.executor.execute(this.afterglowRunnable);
    }

    public void basicDisplayBox(Point origin, Point corner) {
    }

    public Vector<Handle> handles() {
        Vector<Handle> handles = new Vector<Handle>();
        handles.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northWest()));
        handles.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northEast()));
        handles.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southWest()));
        handles.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southEast()));
        return handles;
    }

    public Rectangle displayBox() {
        return this.transitionFigure.displayBox();
    }

    protected void basicMoveBy(int x, int y) {
    }

    public void draw(Graphics g) {
    }

    public boolean inspect(DrawingView view, boolean alternate) {
        if (alternate) {
            if (this.fire()) {
                String name;
                try {
                    name = this.transitionInstance.asString();
                }
                catch (RemoteException e) {
                    name = e.toString();
                }
                view.editor().showStatus("Transition " + name + " fired.");
            } else {
                view.editor().showStatus("No binding for this transition.");
            }
        } else {
            logger.debug((Object)("Searching bindings for " + String.valueOf(this.transitionInstance) + "..."));
            BindingSelectionFrame.open(this.transitionInstance, this.getSimulation());
        }
        return true;
    }

    protected CPNSimulation getSimulation() {
        return ModeReplacement.getInstance().getSimulation();
    }

    public boolean fire() {
        boolean result;
        CPNSimulation simulation = this.getSimulation();
        simulation.getBreakpointManager().clearLog();
        try {
            result = this.transitionInstance.fireOneBinding();
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result = false;
        }
        simulation.simulationRefresh();
        return result;
    }

    public void release() {
        if (this.transitionInstance != null) {
            try {
                this.transitionInstance.removeRemoteEventListener((RemoteEventListener)this.forwarder);
            }
            catch (RemoteException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            this.transitionInstance = null;
        }
        super.release();
    }

    protected TransitionInstanceAccessor getInstance() {
        return this.transitionInstance;
    }
}

