/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.gui.Breakpoint;
import de.renew.gui.BreakpointManager;
import de.renew.net.Net;
import de.renew.net.Transition;
import de.renew.net.TransitionInstance;
import de.renew.net.event.FiringEvent;
import de.renew.net.event.TransitionEventListener;
import de.renew.net.event.TransitionEventProducer;

class TransitionInstanceBreakpoint
implements Breakpoint,
TransitionEventListener {
    private BreakpointManager manager;
    private TransitionEventProducer producer;
    private final int reactOn;
    private final Net net;
    private TransitionInstance hitInstance;
    private String description;

    TransitionInstanceBreakpoint(BreakpointManager manager, TransitionEventProducer producer, int reactOn, Net net) {
        if (reactOn == 0) {
            reactOn = 1;
        }
        producer.addTransitionEventListener((TransitionEventListener)this);
        this.manager = manager;
        this.producer = producer;
        this.reactOn = reactOn;
        this.net = net;
        this.hitInstance = null;
        this.composeDescription();
    }

    public boolean wantSynchronousNotification() {
        return true;
    }

    private void composeDescription() {
        StringBuilder desc = new StringBuilder("BP: ");
        if (this.producer instanceof TransitionInstance) {
            desc.append("transition instance ").append(this.producer);
        } else if (this.producer instanceof Transition) {
            desc.append("transition ").append(this.net.getName()).append(".").append(this.producer);
        } else {
            desc.append("TransitionEventProducer ").append(this.producer);
        }
        switch (this.reactOn) {
            case 1: {
                desc.append(" starts firing");
                break;
            }
            case 2: {
                desc.append(" completes firing");
                break;
            }
            default: {
                desc.append(" <wrong mode!>");
            }
        }
        this.description = desc.toString();
    }

    public void firingStarted(FiringEvent event) {
        if (this.reactOn == 1) {
            this.hitInstance = event.getTransitionInstance();
            this.manager.stopSimulation();
            this.manager.informHitBreakpoint(this);
        }
    }

    public void firingComplete(FiringEvent event) {
        if (this.reactOn == 2) {
            this.hitInstance = event.getTransitionInstance();
            this.manager.stopSimulation();
            this.manager.informHitBreakpoint(this);
        }
    }

    @Override
    public Object getTaggedElement() {
        return this.producer;
    }

    @Override
    public Object getHitElement() {
        return this.hitInstance;
    }

    @Override
    public void release() {
        this.producer.removeTransitionEventListener((TransitionEventListener)this);
        this.manager = null;
        this.producer = null;
        this.hitInstance = null;
    }

    @Override
    public Net getTaggedNet() {
        return this.net;
    }

    public String toString() {
        return this.description;
    }
}

