/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.standard.FigureException;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenuItem;
import de.renew.application.IllegalCompilerException;
import de.renew.application.NoSimulationException;
import de.renew.application.SimulationEnvironment;
import de.renew.application.SimulationRunningException;
import de.renew.application.SimulatorExtension;
import de.renew.application.SimulatorExtensionAdapter;
import de.renew.application.SimulatorPlugin;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.formalism.FormalismPlugin;
import de.renew.gui.BindingSelectionFrame;
import de.renew.gui.Breakpoint;
import de.renew.gui.BreakpointHitEvent;
import de.renew.gui.BreakpointHitListener;
import de.renew.gui.BreakpointManager;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.CPNSimulation;
import de.renew.gui.ConfigureSimulationCommand;
import de.renew.gui.FigureExceptionFactory;
import de.renew.gui.GuiPlugin;
import de.renew.gui.InstanceDrawing;
import de.renew.gui.InstanceFigure;
import de.renew.gui.ModeReplacement;
import de.renew.gui.OpenServerFrameCommand;
import de.renew.gui.TransitionInstanceFigure;
import de.renew.gui.nin.ConstructionGUI;
import de.renew.gui.nin.SystemNetBuilder;
import de.renew.io.SimulationStateFileFilter;
import de.renew.net.IDRegistry;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.NetInstance;
import de.renew.net.NetNotFoundException;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.net.Transition;
import de.renew.net.TransitionInstance;
import de.renew.remote.MarkingAccessor;
import de.renew.remote.NetAccessor;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.RemotePlugin;
import de.renew.remote.TransitionAccessor;
import de.renew.remote.TransitionInstanceAccessor;
import de.renew.remote.TransitionInstanceAccessorImpl;
import de.renew.shadow.SyntaxException;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class SimulationMenuCreator {
    private static final Logger logger = Logger.getLogger(SimulationMenuCreator.class);
    private static final Lock lock = new ReentrantLock();

    public Collection<JMenuItem> createMenus(BreakpointManager bpm) {
        MenuManager.SeparatorFactory sepFac = new MenuManager.SeparatorFactory("de.renew.gui.simulation");
        ArrayList<JMenuItem> result = new ArrayList<JMenuItem>();
        result.add(DrawApplication.createMenuItem((String)"Run simulation", (int)82, event -> this.runSimulation()));
        result.add(DrawApplication.createMenuItem((String)"Simulation Step", (int)73, event -> this.simulationStep()));
        result.add((JMenuItem)new CommandMenuItem((Command)new SimulationNetStepCommand("Simulation Net Step"), 73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() + 64));
        int modifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            modifier += 64;
        }
        result.add((JMenuItem)new CommandMenuItem((Command)new SimulationHaltCommand(), 72, modifier));
        result.add((JMenuItem)new CommandMenuItem((Command)new SimulationTerminateCommand(), 84));
        result.add(sepFac.createSeparator());
        result.add((JMenuItem)new CommandMenuItem((Command)new ConfigureSimulationCommand("Configure Simulation...")));
        result.add(bpm.getSimulationMenu());
        result.add(sepFac.createSeparator());
        result.add((JMenuItem)new CommandMenuItem((Command)new SaveSimulationStateCommand()));
        result.add((JMenuItem)new CommandMenuItem((Command)new LoadSimulationStateCommand()));
        result.add(sepFac.createSeparator());
        result.add((JMenuItem)new CommandMenuItem((Command)new OpenServerFrameCommand("Remote Server...")));
        return result;
    }

    private void simulationStep() {
        SimulationThreadPool.getCurrent().execute(() -> {
            GuiPlugin plugin = GuiPlugin.getCurrent();
            CPNSimulation simulation = this.getSimulation();
            if (!simulation.isSimulationActive()) {
                this.initSimulation();
            } else {
                plugin.showStatus("Searching for a binding...");
                int status = simulation.simulationStep();
                switch (status) {
                    case 0: {
                        if (simulation.isSimulationActive()) {
                            plugin.showStatus("Simulation halted.");
                            break;
                        }
                        plugin.showStatus("Simulation terminated.");
                        break;
                    }
                    case 1: {
                        plugin.showStatus("Simulation step completed.");
                        break;
                    }
                    case 2: {
                        plugin.showStatus("Simulation step completed. No more enabled bindings.");
                        break;
                    }
                    case 3: {
                        plugin.showStatus("No enabled bindings found.");
                        break;
                    }
                    case 4: {
                        plugin.showStatus("No more enabled bindings.");
                    }
                }
            }
        });
    }

    private void runSimulation() {
        try {
            lock.lock();
            GuiPlugin plugin = GuiPlugin.getCurrent();
            CPNSimulation simulation = this.getSimulation();
            if (!simulation.isSimulationActive()) {
                simulation.getSimulatorPlugin().addExtension((SimulatorExtension)new SimulatorExtensionAdapter(){

                    public void simulationSetup(SimulationEnvironment env) {
                        CPNSimulation simulation = SimulationMenuCreator.this.getSimulation();
                        simulation.simulationRun();
                        simulation.getSimulatorPlugin().removeExtension((SimulatorExtension)this);
                    }
                });
                this.initSimulation();
            } else {
                plugin.showStatus("Simulation running.");
                simulation.simulationRun();
            }
        }
        finally {
            lock.unlock();
        }
    }

    void initSimulation() {
        SimulatorPlugin.lock.lock();
        try {
            SimulationThreadPool.getNew().execute(() -> {
                String netName;
                GuiPlugin plugin = GuiPlugin.getCurrent();
                CPNApplication app = plugin.getGui();
                app.showStatus("Starting Simulation ...");
                if (!(app.drawing() instanceof CPNDrawing)) {
                    app.showStatus("Cannot start new simulation with this drawing! Please activate a net window.");
                    return;
                }
                SystemNetBuilder systemNetBuilder = null;
                if (Objects.requireNonNull(FormalismPlugin.getCurrent()).getCompiler().equals("P/T Net in Net Compiler")) {
                    systemNetBuilder = this.initSystemNet(app);
                    if (systemNetBuilder == null) {
                        return;
                    }
                    netName = systemNetBuilder.getSystemNet().getName();
                } else {
                    netName = GuiPlugin.getCurrent().getDrawingEditor().drawing().getName();
                }
                try {
                    NetInstanceAccessor primaryInstance = this.getSimulation().initSimulation(netName);
                    SystemNetBuilder finalSystemNetBuilder = systemNetBuilder;
                    EventQueue.invokeLater(() -> {
                        if (primaryInstance != null) {
                            app.openInstanceDrawing(primaryInstance);
                            if (Objects.requireNonNull(FormalismPlugin.getCurrent()).getCompiler().equals("P/T Net in Net Compiler")) {
                                this.fireCreateTransition(primaryInstance, finalSystemNetBuilder);
                                this.openAllSimulatedNetInstances(primaryInstance, finalSystemNetBuilder, app);
                            }
                            if (this.getSimulation().isSimulationActive()) {
                                app.showStatus("Simulation initialized.");
                            } else {
                                app.showStatus("Simulation initialized. No enabled bindings.");
                            }
                        } else {
                            app.showStatus("The simulation could not be initialized.");
                        }
                    });
                }
                catch (SyntaxException e) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                    EventQueue.invokeLater(() -> plugin.processSyntaxException(FigureExceptionFactory.createFigureException(e), true));
                }
                catch (NetNotFoundException e1) {
                    logger.warn((Object)e1.getMessage(), (Throwable)e1);
                    plugin.showStatus("Net \"" + netName + "\" not found although the drawing exists (should not happen).");
                }
                catch (IllegalCompilerException e1) {
                    logger.warn((Object)e1.getMessage(), (Throwable)e1);
                    plugin.showStatus("No compiler selected. Please choose a formalism.");
                }
                catch (NoSimulationException e1) {
                    logger.debug((Object)e1.getMessage(), (Throwable)e1);
                    plugin.showStatus("Simulation aborted during initialization.");
                }
                catch (RuntimeException e1) {
                    logger.warn((Object)("Simulation initialization failed: " + String.valueOf(e1)), (Throwable)e1);
                    plugin.showStatus("Simulation initialization failed: " + e1.getMessage());
                }
                catch (Error e1) {
                    logger.error((Object)("Simulation initialization failed: " + String.valueOf(e1)), (Throwable)e1);
                    plugin.showStatus("Simulation initialization failed: " + String.valueOf(e1));
                }
            });
        }
        finally {
            SimulatorPlugin.lock.unlock();
        }
    }

    void promptLoadSimulationState() {
        GuiPlugin plugin = GuiPlugin.getCurrent();
        CPNApplication gui = plugin.getGui();
        File path = DrawPlugin.getCurrent().getIOHelper().getLoadPath(null, (FileFilter)((Object)new SimulationStateFileFilter()));
        if (path != null) {
            BindingSelectionFrame.close();
            gui.closeAllSimulationDrawings();
            Object message = null;
            ObjectInput input = null;
            try {
                GuiPlugin.getCurrent().showStatus("Importing " + String.valueOf(path) + " ...");
                FileInputStream stream = new FileInputStream(path);
                input = new RenewObjectInputStream((InputStream)stream);
                ModeReplacement.getInstance().getSimulation().loadState(input);
                plugin.showStatus("Imported " + String.valueOf(path) + ".");
            }
            catch (SimulationRunningException e) {
                message = "Cannot load state into running simulation";
            }
            catch (ObjectStreamException e) {
                message = "File " + String.valueOf(path) + " is corrupted or does not contain state information.";
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                message = "File " + String.valueOf(path) + " refers to java classes which are currently not available.";
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                message = "Problem occured while reading file " + String.valueOf(path) + ":" + String.valueOf(e);
            }
            catch (StackOverflowError e) {
                message = "StackOverflowError: Probably the recursion in Java's serialization mechanism went too deep.\nIf you are using JDK 1.1, try setting the java options  -ss... and/or -oss... to increase native and java stack sizes. Setting -ss1m was appropriate for us.";
            }
            try {
                if (input != null) {
                    input.close();
                }
                if (message == null) {
                    message = "Simulation state restored from " + String.valueOf(path) + ".";
                }
            }
            catch (StreamCorruptedException e) {
                if (message == null) {
                    message = "Problem occurred while reading file " + String.valueOf(path) + ", but all relevant information was already read. Perhaps the simulation state is valid anyway.";
                    logger.error((Object)("Exception while closing: " + String.valueOf(e)));
                }
            }
            catch (Exception e) {
                if (message == null) {
                    message = "Problem occurred while reading file " + String.valueOf(path) + ", but all relevant information was already read. Perhaps the simulation state is valid anyway.";
                }
                logger.error((Object)("Exception while closing: " + String.valueOf(e)));
            }
            plugin.showStatus((String)message);
            logger.error(message);
        }
    }

    void promptSaveSimulationState() {
        GuiPlugin plugin = GuiPlugin.getCurrent();
        if (!ModeReplacement.getInstance().getSimulation().isSimulationActive()) {
            plugin.showStatus("Need running simulation to save state.");
        } else {
            File file = DrawPlugin.getCurrent().getIOHelper().getSavePath(null, (SimpleFileFilter)new SimulationStateFileFilter());
            if (file != null) {
                Stack problemLocation;
                Object message;
                block13: {
                    String path = file.getAbsolutePath();
                    message = null;
                    problemLocation = null;
                    RenewObjectOutputStream output = null;
                    try {
                        plugin.showStatus("Exporting " + path + " ...");
                        FileOutputStream stream = new FileOutputStream(path);
                        output = new RenewObjectOutputStream((OutputStream)stream);
                        ModeReplacement.getInstance().getSimulation().saveState((ObjectOutput)output);
                        plugin.showStatus("Exported " + path + ".");
                    }
                    catch (NotSerializableException e) {
                        message = "Some object or class is not serializable: " + e.getMessage() + ".\nWriting of file " + path + " aborted.";
                        problemLocation = output != null ? output.getDomainTrace() : null;
                        logger.debug((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (Exception e) {
                        message = "Problem encountered while writing file " + path + ": " + String.valueOf(e);
                        logger.debug((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (StackOverflowError e) {
                        message = "StackOverflowError: Probably the recursion in Java's serialization mechanism went too deep.\nIf you are using JDK 1.1, try setting the java options  -ss... and/or -oss... to increase native and java stack sizes. Setting -ss1m was appropriate for us.";
                        logger.debug((Object)e.getMessage(), (Throwable)e);
                    }
                    try {
                        if (output != null) {
                            output.close();
                        }
                        if (message == null) {
                            message = "Simulation state saved to " + path + ".";
                        }
                    }
                    catch (Exception e) {
                        if (message != null) break block13;
                        message = "Problem encountered while closing file " + path + ": " + String.valueOf(e);
                    }
                }
                if (problemLocation != null) {
                    this.displaySaveSimError(problemLocation, (String)message);
                } else {
                    plugin.showStatus((String)message);
                    logger.error(message);
                }
            }
        }
    }

    private void displaySaveSimError(Stack<Object> objectLocation, String message) {
        try {
            boolean appendTrace;
            GuiPlugin plugin = GuiPlugin.getCurrent();
            NetAccessor net = null;
            NetInstanceAccessor netInstance = null;
            int id = 0;
            Object thisShouldNotHappen = null;
            String specialReason = null;
            Object netElement = null;
            CPNDrawing drawing = null;
            String netName = null;
            try {
                netElement = objectLocation.peek();
                RemotePlugin remote = RemotePlugin.getInstance();
                if (netElement instanceof PlaceInstance) {
                    PlaceInstance placeInstance = (PlaceInstance)netElement;
                    PlaceInstanceAccessor placeInst = remote.wrapInstance(placeInstance);
                    id = placeInst.getPlace().getID().getFigureID();
                    netInstance = placeInst.getNetInstance();
                    net = netInstance.getNet();
                } else if (netElement instanceof TransitionInstance) {
                    TransitionInstance transitionInstance = (TransitionInstance)netElement;
                    TransitionInstanceAccessor transitionInst = remote.wrapInstance(transitionInstance);
                    id = transitionInst.getTransition().getID().getFigureID();
                    netInstance = transitionInst.getNetInstance();
                    net = netInstance.getNet();
                } else if (netElement instanceof Place) {
                    Place place = (Place)netElement;
                    thisShouldNotHappen = "place " + String.valueOf(netElement);
                    id = place.getID().getFigureID();
                } else if (netElement instanceof TransitionAccessor) {
                    thisShouldNotHappen = "transition " + String.valueOf(netElement);
                    id = ((Transition)netElement).getID().getFigureID();
                } else if (netElement instanceof Net) {
                    Net net1 = (Net)netElement;
                    thisShouldNotHappen = "net " + String.valueOf(netElement);
                    net = remote.wrapNet(net1);
                } else if (netElement instanceof NetInstance) {
                    NetInstance netInstance1 = (NetInstance)netElement;
                    thisShouldNotHappen = "net instance " + String.valueOf(netElement);
                    netInstance = remote.wrapInstance(netInstance1);
                    net = netInstance.getNet();
                } else if (netElement instanceof IDRegistry) {
                    thisShouldNotHappen = "a token ID registry";
                } else if (netElement == SimulatorPlugin.class) {
                    thisShouldNotHappen = "instance drawings";
                } else if (netElement == Net.class) {
                    thisShouldNotHappen = "compiled nets";
                } else if (netElement == SearchQueue.class) {
                    thisShouldNotHappen = "search queue entries";
                    if (((String)message).contains("de.renew.call.SynchronisationRequest")) {
                        specialReason = "You tried to save the simulation state while a Java call to a net method was still active. Wait until all methods have completed.";
                    }
                } else {
                    thisShouldNotHappen = "(DON'T KNOW - TRACE CONTAINS OBJECT OF UNEXPECTED TYPE: " + netElement.getClass().getName() + ")";
                }
            }
            catch (EmptyStackException e) {
                thisShouldNotHappen = "(DON'T KNOW - TRACE IS EMPTY!?)";
            }
            catch (NoSimulationException e) {
                thisShouldNotHappen = "(DON'T KNOW - NO LOCAL SIMULATION RU)";
            }
            if (thisShouldNotHappen == null) {
                netName = net != null ? net.getName() : null;
                message = (String)message + "\nThe problem lies around net element " + String.valueOf(netElement) + ".";
                drawing = ModeReplacement.getInstance().getDrawingLoader().getDrawing(netName);
                appendTrace = true;
            } else {
                message = specialReason == null ? (String)message + "\nDid you try to save a state while the simulation was running (concurrent transition firing or binding calculation is not allowed)?" : (String)message + "\n" + specialReason;
                message = (String)message + "\nThe problem manifested itself while writing " + (String)thisShouldNotHappen + ".";
                appendTrace = true;
            }
            if (appendTrace) {
                message = (String)message + "\nSerialization trace:";
                try {
                    StringBuilder messageBuilder = new StringBuilder((String)message);
                    while (!objectLocation.isEmpty()) {
                        netElement = objectLocation.pop();
                        messageBuilder.append("\n    ").append(netElement);
                        if (net != null || netInstance != null) continue;
                        try {
                            RemotePlugin remote = RemotePlugin.getInstance();
                            if (netElement instanceof Net) {
                                Net net1 = (Net)netElement;
                                net = remote.wrapNet(net1);
                                continue;
                            }
                            if (!(netElement instanceof NetInstance)) continue;
                            NetInstance netInstance1 = (NetInstance)netElement;
                            netInstance = remote.wrapInstance(netInstance1);
                            net = netInstance.getNet();
                        }
                        catch (NoSimulationException remote) {}
                    }
                    message = messageBuilder.toString();
                }
                catch (EmptyStackException messageBuilder) {
                    // empty catch block
                }
            }
            if (thisShouldNotHappen == null) {
                if (drawing == null) {
                    plugin.showStatus((String)message);
                    logger.error(message);
                    logger.error((Object)("Sorry, cannot show the location of the problem because net " + netName + " is not loaded."));
                } else {
                    GuiPlugin.getCurrent().getGui().openInstanceDrawing(netInstance);
                    InstanceDrawing instanceDrawing = CPNInstanceDrawing.getInstanceDrawing(netInstance);
                    FigureWithID figure = drawing.getFigureWithID(id);
                    InstanceFigure instanceFigure = instanceDrawing.getInstanceFigure((Figure)figure);
                    plugin.showStatus((String)message);
                    logger.error(message);
                    GuiPlugin.getCurrent().processFigureException(new FigureException("Renew: Save simulation error", (String)message, (Drawing)instanceDrawing, (Figure)instanceFigure), false);
                }
            } else {
                FigureWithID figure;
                plugin.showStatus((String)message);
                logger.error(message);
                if (net != null && id != 0 && (drawing = ModeReplacement.getInstance().getDrawingLoader().getDrawing(net.getName())) != null && (figure = drawing.getFigureWithID(id)) != null) {
                    if (netInstance != null) {
                        try {
                            InstanceDrawing instanceDrawing = CPNInstanceDrawing.getInstanceDrawing(netInstance);
                            plugin.processFigureException(new FigureException("Renew: Save simulation error", (String)message, (Drawing)instanceDrawing, (Figure)figure), false);
                        }
                        catch (RemoteException e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            JOptionPane.showMessageDialog(null, "A problem occurred: " + String.valueOf(e) + "\nSee the console for details.", "Renew", 0);
                        }
                    } else {
                        plugin.processFigureException(new FigureException("Renew: Save simulation error", (String)message, (Drawing)drawing, (Figure)figure), false);
                    }
                }
            }
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            JOptionPane.showMessageDialog(null, "A problem occurred: " + String.valueOf(e) + "\nSee the console for details.", "Renew", 0);
        }
    }

    private SystemNetBuilder initSystemNet(CPNApplication app) {
        if (!app.syntaxCheck()) {
            app.showStatus("Invalid net syntax!");
            return null;
        }
        Enumeration drawingEnumeration = app.drawings();
        while (drawingEnumeration.hasMoreElements()) {
            Drawing drawing = (Drawing)drawingEnumeration.nextElement();
            String drawingName = drawing.getName();
            if (drawingName.equals("SystemNet")) {
                app.closeDrawing(drawing);
                continue;
            }
            if (!drawingName.matches(".*\\d.*")) continue;
            app.showStatus("Net name contains integer!");
            return null;
        }
        ConstructionGUI constructionSettings = new ConstructionGUI(app);
        SystemNetBuilder systemNetBuilder = constructionSettings.getNetBuilder();
        if (systemNetBuilder != null) {
            CPNDrawing systemNet = systemNetBuilder.getSystemNet();
            app.openDrawing(systemNet);
        }
        return systemNetBuilder;
    }

    private void openAllSimulatedNetInstances(NetInstanceAccessor primaryInstance, SystemNetBuilder systemNetBuilder, CPNApplication app) {
        try {
            NetAccessor net = primaryInstance.getNet();
            int referencePlaceID = systemNetBuilder.getReferencePlaceID();
            for (NetElementID netElementID : net.getPlaceIDs()) {
                if (netElementID.getFigureID() != referencePlaceID) continue;
                MarkingAccessor markAccess = primaryInstance.getPlaceInstance(netElementID).getMarking();
                int numOfReferences = markAccess.getDistinctTokenCount();
                for (int i = 0; i < numOfReferences; ++i) {
                    app.openInstanceDrawing(markAccess.getToken(i).asNetInstance());
                }
            }
        }
        catch (RemoteException e) {
            logger.error((Object)"Could not open net instances.");
        }
    }

    private void fireCreateTransition(NetInstanceAccessor primaryInstance, SystemNetBuilder systemNetBuilder) {
        try {
            int createTransitionID = systemNetBuilder.getCreateTransitionID();
            NetAccessor net = primaryInstance.getNet();
            for (NetElementID netElementID : net.getTransitionIDs()) {
                if (netElementID.getFigureID() != createTransitionID) continue;
                primaryInstance.getTransitionInstance(netElementID).fireOneBinding();
            }
        }
        catch (RemoteException e) {
            logger.error((Object)"Could not create new net instances.");
        }
    }

    protected CPNSimulation getSimulation() {
        return ModeReplacement.getInstance().getSimulation();
    }

    private class SimulationNetStepCommand
    extends Command {
        public SimulationNetStepCommand(String name) {
            super(name);
        }

        public void execute() {
            SimulationThreadPool.getCurrent().execute(() -> {
                CPNSimulation simulation = SimulationMenuCreator.this.getSimulation();
                if (!simulation.isSimulationActive()) {
                    SimulationMenuCreator.this.initSimulation();
                    return;
                }
                GuiPlugin plugin = GuiPlugin.getCurrent();
                BreakpointManager bpm = simulation.getBreakpointManager();
                DrawingView view = DrawPlugin.getCurrent().getDrawingEditor().view();
                Drawing drawing = view.drawing();
                if (!(drawing instanceof CPNInstanceDrawing)) {
                    plugin.showStatus("A net instance drawing must be selected.");
                    return;
                }
                ArrayList<Figure> figures = Collections.list(drawing.figures());
                ArrayList<Breakpoint> addedBPs = new ArrayList<Breakpoint>();
                for (Figure figure : figures) {
                    if (!(figure instanceof TransitionInstanceFigure)) continue;
                    TransitionInstanceFigure tiFigure = (TransitionInstanceFigure)figure;
                    TransitionInstanceAccessor accessor = tiFigure.getInstance();
                    if (!(accessor instanceof TransitionInstanceAccessorImpl)) {
                        plugin.showStatus("The net step feature is only enabled for local simulations.");
                        return;
                    }
                    TransitionInstance instance = ((TransitionInstanceAccessorImpl)accessor).getTransitionInstance();
                    addedBPs.add(bpm.createTransitionInstanceBreakpoint(instance, 2));
                }
                HitListener listener = new HitListener(addedBPs, plugin, simulation);
                bpm.addBreakpointHitListener(listener);
                plugin.showStatus("waiting for next transition firing in this net instance...");
                simulation.simulationRun();
            });
        }
    }

    private class SimulationHaltCommand
    extends Command {
        public SimulationHaltCommand() {
            super("Halt simulation");
        }

        public boolean isExecutable() {
            if (!super.isExecutable()) {
                return false;
            }
            return SimulationMenuCreator.this.getSimulation().isSimulationActive();
        }

        public void execute() {
            SimulationMenuCreator.this.getSimulation().simulationStop();
            GuiPlugin.getCurrent().showStatus("Simulation halted.");
        }
    }

    private class SimulationTerminateCommand
    extends Command {
        public SimulationTerminateCommand() {
            super("Terminate simulation");
        }

        public boolean isExecutable() {
            if (!super.isExecutable()) {
                return false;
            }
            return SimulationMenuCreator.this.getSimulation().isSimulationActive();
        }

        public void execute() {
            SimulationMenuCreator.this.getSimulation().simulationTerminate();
        }
    }

    private class SaveSimulationStateCommand
    extends Command {
        public SaveSimulationStateCommand() {
            super("Save simulation state...");
        }

        public boolean isExecutable() {
            if (!super.isExecutable()) {
                return false;
            }
            return SimulationMenuCreator.this.getSimulation().isSimulationActive();
        }

        public void execute() {
            SimulationMenuCreator.this.promptSaveSimulationState();
        }
    }

    private class LoadSimulationStateCommand
    extends Command {
        public LoadSimulationStateCommand() {
            super("Load simulation state...");
        }

        public void execute() {
            SimulationMenuCreator.this.promptLoadSimulationState();
        }
    }

    private static class HitListener
    implements BreakpointHitListener {
        private final List<Breakpoint> bps;
        private final StatusDisplayer statusDisplayer;
        private final CPNSimulation simulation;

        private HitListener(List<Breakpoint> bps, StatusDisplayer statusDisplayer, CPNSimulation simulation) {
            this.bps = bps;
            this.statusDisplayer = statusDisplayer;
            this.simulation = simulation;
        }

        @Override
        public void hitBreakpoint(BreakpointHitEvent event) {
            if (this.bps.contains(event.getBp())) {
                event.consume();
                if (this.simulation.isSimulationActive()) {
                    this.statusDisplayer.showStatus("Simulation halted.");
                } else {
                    this.statusDisplayer.showStatus("Simulation terminated.");
                }
                BreakpointManager bpm = this.simulation.getBreakpointManager();
                for (Breakpoint bp : this.bps) {
                    bpm.deleteBreakpoint(bp);
                }
                bpm.removeBreakpointHitListener(this);
            }
        }
    }
}

