/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.gui.Breakpoint;
import de.renew.gui.BreakpointManager;
import de.renew.net.Net;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.net.event.PlaceEvent;
import de.renew.net.event.PlaceEventListener;
import de.renew.net.event.PlaceEventProducer;
import de.renew.net.event.TokenEvent;

class PlaceInstanceBreakpoint
implements Breakpoint,
PlaceEventListener {
    private BreakpointManager manager;
    private final int reactOn;
    private PlaceEventProducer producer;
    private Net net;
    private PlaceInstance hitInstance;
    private String description;

    PlaceInstanceBreakpoint(BreakpointManager manager, PlaceEventProducer producer, int reactOn, Net net) {
        if (reactOn == 0) {
            reactOn = 3;
        }
        producer.addPlaceEventListener((PlaceEventListener)this);
        this.manager = manager;
        this.reactOn = reactOn;
        this.producer = producer;
        this.net = net;
        this.hitInstance = null;
        this.composeDescription();
    }

    public boolean wantSynchronousNotification() {
        return true;
    }

    private void composeDescription() {
        StringBuilder desc = new StringBuilder("BP: ");
        if (this.producer instanceof PlaceInstance) {
            desc.append("place instance ").append(this.producer);
        } else if (this.producer instanceof Place) {
            desc.append("place ").append(this.net.getName()).append(".").append(this.producer);
        } else {
            desc.append("PlaceEventProducer ").append(this.producer);
        }
        switch (this.reactOn) {
            case 3: {
                desc.append(" changes marking");
                break;
            }
            case 5: {
                desc.append(" changes marking (test arcs ignored)");
                break;
            }
            case 6: {
                desc.append(" gets one token added");
                break;
            }
            case 7: {
                desc.append(" looses one token");
                break;
            }
            case 8: {
                desc.append(" changes test status of tokens");
                break;
            }
            default: {
                desc.append(" <wrong mode!>");
            }
        }
        this.description = desc.toString();
    }

    private void hitBP(PlaceEvent event) {
        this.hitInstance = event.getPlaceInstance();
        this.manager.stopSimulation();
        this.manager.informHitBreakpoint(this);
    }

    public void markingChanged(PlaceEvent event) {
        switch (this.reactOn) {
            case 3: 
            case 5: {
                this.hitBP(event);
            }
        }
    }

    public void tokenAdded(TokenEvent event) {
        switch (this.reactOn) {
            case 3: 
            case 5: 
            case 6: {
                this.hitBP((PlaceEvent)event);
            }
        }
    }

    public void tokenRemoved(TokenEvent event) {
        switch (this.reactOn) {
            case 3: 
            case 5: 
            case 7: {
                this.hitBP((PlaceEvent)event);
            }
        }
    }

    public void tokenTested(TokenEvent event) {
        switch (this.reactOn) {
            case 3: 
            case 8: {
                this.hitBP((PlaceEvent)event);
            }
        }
    }

    public void tokenUntested(TokenEvent event) {
        switch (this.reactOn) {
            case 3: 
            case 8: {
                this.hitBP((PlaceEvent)event);
            }
        }
    }

    @Override
    public Object getTaggedElement() {
        return this.producer;
    }

    @Override
    public Object getHitElement() {
        return this.hitInstance;
    }

    @Override
    public Net getTaggedNet() {
        return this.net;
    }

    @Override
    public void release() {
        this.producer.removePlaceEventListener((PlaceEventListener)this);
        this.manager = null;
        this.producer = null;
        this.net = null;
        this.hitInstance = null;
    }

    public String toString() {
        return this.description;
    }
}

