/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureFilter;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.standard.FilteredFigureEnumerator;
import de.renew.gui.ArcConnection;
import de.renew.gui.NodeFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import java.util.HashSet;
import java.util.Set;

public class CoarseCommand
extends UndoableCommand {
    public CoarseCommand(String name) {
        super(name);
    }

    public boolean executeUndoable() {
        if (this.isExecutable()) {
            if (!super.isExecutable()) {
                return false;
            }
            Drawing drawing = this.getEditor().drawing();
            DrawingView view = this.getEditor().view();
            FigureEnumeration selected = view.selectionElements();
            int i = 1;
            FilteredFigureEnumerator borderFigures = new FilteredFigureEnumerator(selected, (FigureFilter)new BorderFigureFilter());
            HashSet<Figure> borderSet = new HashSet<Figure>();
            NodeFigure finalFig = (NodeFigure)borderFigures.nextFigure();
            borderSet.add(finalFig);
            while (borderFigures.hasMoreElements()) {
                borderSet.add(borderFigures.nextFigure());
            }
            selected = view.selectionElements();
            int finalx = finalFig.center().x;
            int finaly = finalFig.center().y;
            while (selected.hasMoreElements()) {
                Figure nextFig = selected.nextFigure();
                if (nextFig.equals(finalFig) || !(nextFig instanceof TransitionFigure) && !(nextFig instanceof PlaceFigure)) continue;
                FigureEnumeration figures = drawing.figures();
                while (figures.hasMoreElements()) {
                    Figure fig = figures.nextFigure();
                    if (!(fig instanceof ArcConnection)) continue;
                    ArcConnection arc = (ArcConnection)fig;
                    if (arc.startFigure().equals(nextFig)) {
                        if (borderSet.contains(nextFig)) {
                            arc.disconnectStart();
                            arc.connectStart(finalFig.connectorAt(finalFig.center().x, finalFig.center().y));
                            arc.updateConnection();
                        } else {
                            view.remove((Figure)arc);
                        }
                    }
                    if (!arc.endFigure().equals(nextFig)) continue;
                    if (borderSet.contains(nextFig)) {
                        arc.disconnectEnd();
                        arc.connectEnd(finalFig.connectorAt(finalFig.center().x, finalFig.center().y));
                        arc.updateConnection();
                        continue;
                    }
                    view.remove((Figure)arc);
                }
                if (nextFig instanceof TransitionFigure && finalFig instanceof TransitionFigure || nextFig instanceof PlaceFigure && finalFig instanceof PlaceFigure) {
                    ParentFigure parent = (ParentFigure)nextFig;
                    while (parent.children().hasMoreElements()) {
                        ChildFigure fig = (ChildFigure)parent.children().nextFigure();
                        fig.setParent((ParentFigure)finalFig);
                        drawing.bringToFront((Figure)fig);
                    }
                }
                ++i;
                finalx += nextFig.center().x;
                finaly += nextFig.center().y;
                view.remove(nextFig);
            }
            finalFig.moveBy((finalx /= i) - finalFig.center().x, (finaly /= i) - finalFig.center().y);
            view.checkDamage();
            return true;
        }
        return false;
    }

    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        DrawingView view = this.getEditor().view();
        FigureEnumeration selected = view.selectionElements();
        FilteredFigureEnumerator borderFigures = new FilteredFigureEnumerator(selected, (FigureFilter)new BorderFigureFilter());
        Figure firstFig = borderFigures.nextFigure();
        if (firstFig instanceof TransitionFigure) {
            while (borderFigures.hasMoreElements()) {
                if (borderFigures.nextFigure() instanceof TransitionFigure) continue;
                return false;
            }
            return true;
        }
        if (firstFig instanceof PlaceFigure) {
            while (borderFigures.hasMoreElements()) {
                if (borderFigures.nextFigure() instanceof PlaceFigure) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    class BorderFigureFilter
    implements FigureFilter {
        final Set<Figure> selectedSet;

        public BorderFigureFilter() {
            DrawingView view = CoarseCommand.this.getEditor().view();
            FigureEnumeration selected = view.selectionElements();
            this.selectedSet = new HashSet<Figure>();
            while (selected.hasMoreElements()) {
                this.selectedSet.add(selected.nextFigure());
            }
        }

        public boolean isUsed(Figure figure) {
            if (figure instanceof TransitionFigure || figure instanceof PlaceFigure) {
                FigureEnumeration figures = CoarseCommand.this.getEditor().drawing().figures();
                while (figures.hasMoreElements()) {
                    ArcConnection arc;
                    Figure fig = figures.nextFigure();
                    if (!(fig instanceof ArcConnection) || (!(arc = (ArcConnection)fig).startFigure().equals(figure) || this.selectedSet.contains(arc.endFigure())) && (!arc.endFigure().equals(figure) || this.selectedSet.contains(arc.startFigure()))) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

