/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class ChangeSizeCommand
extends UndoableCommand {
    public static final int DEFAULT_SIZE = 1;
    public static final int FIRST_FIGURE = 2;
    private static final int SPECIFIED = 0;
    private final int mode;
    private Dimension useSize;

    public ChangeSizeCommand(String name, int mode) {
        super(name);
        if (mode == 0) {
            throw new RuntimeException("ChangeSizeCommand: Invalid mode.");
        }
        this.mode = mode;
        this.useSize = null;
    }

    public ChangeSizeCommand(String name, Dimension size) {
        super(name);
        this.mode = 0;
        this.useSize = size;
    }

    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        if (this.mode == 2) {
            return this.getEditor().view().selectionCount() > 1;
        }
        return this.getEditor().view().selectionCount() > 0;
    }

    public synchronized boolean executeUndoable() {
        if (this.isExecutable()) {
            if (!super.isExecutable()) {
                return false;
            }
            FigureEnumeration figures = this.getEditor().view().selectionElements();
            if (this.mode == 2) {
                Figure firstFigure = figures.nextFigure();
                this.useSize = firstFigure.displayBox().getSize();
            }
            while (figures.hasMoreElements()) {
                Figure figure = figures.nextFigure();
                Rectangle oldBox = figure.displayBox();
                Point oldLoc = oldBox.getLocation();
                Dimension oldDim = oldBox.getSize();
                Dimension newDim = this.getNewSize(figure);
                if (newDim == null) continue;
                Point newLoc = new Point(oldLoc.x - (newDim.width - oldDim.width) / 2, oldLoc.y - (newDim.height - oldDim.height) / 2);
                Rectangle newBox = new Rectangle(newLoc, newDim);
                figure.displayBox(newBox);
            }
            this.getEditor().view().checkDamage();
            return true;
        }
        return false;
    }

    protected Dimension getNewSize(Figure figure) {
        if (this.mode == 1) {
            if (figure instanceof PlaceFigure) {
                return PlaceFigure.defaultDimension();
            }
            if (figure instanceof TransitionFigure) {
                return TransitionFigure.defaultDimension();
            }
            return null;
        }
        return this.useSize;
    }
}

