/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.gui.InscribableFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.ShadowHolder;
import de.renew.gui.TransitionFigure;
import de.renew.shadow.ShadowInscribable;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;
import de.renew.shadow.ShadowNode;
import java.awt.Color;
import java.io.IOException;

public class CPNTextFigure
extends TextFigure
implements ShadowHolder {
    public static final int LABEL = 0;
    public static final int INSCRIPTION = 1;
    public static final int NAME = 2;
    public static final int AUX = 3;
    public static final int COMM = 4;
    public static final int[] STYLE = new int[]{2, 0, 1, 3, 0};
    public static final CPNTextFigure Label = new CPNTextFigure(0);
    public static final CPNTextFigure Inscription = new CPNTextFigure(1);
    public static final CPNTextFigure Name = new CPNTextFigure(2);
    public static final CPNTextFigure Aux = new CPNTextFigure(3);
    public static final CPNTextFigure Comm = new CPNTextFigure(4);
    protected int fType;
    protected transient ShadowInscription shadow = null;

    public CPNTextFigure() {
        this(0);
    }

    public CPNTextFigure(int type) {
        this(type, true);
    }

    public CPNTextFigure(int type, boolean canBeConnected) {
        super(canBeConnected);
        this.fType = type;
        this.setAttribute("FontStyle", STYLE[type]);
        if (this.fType == 4) {
            this.setTextColor(Color.BLUE);
        }
        this.setAlignment(1);
    }

    public int getType() {
        return this.fType;
    }

    public void setAttribute(String name, Object value) {
        if (name.equals("TextType")) {
            int newType = (Integer)value;
            if (this.canBeParent(newType, this.parent())) {
                this.willChange();
                this.fType = newType;
                super.setAttribute("FontStyle", (Object)STYLE[this.fType]);
            }
        } else {
            super.setAttribute(name, value);
        }
    }

    public Object getAttribute(String name) {
        if (name.equals("TextType")) {
            return this.fType;
        }
        return super.getAttribute(name);
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fType);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fType = dr.readInt();
    }

    protected void readWithoutType(StorableInput dr) throws IOException {
        super.read(dr);
        this.fType = 1;
    }

    protected boolean canBeParent(int type, ParentFigure parent) {
        return switch (type) {
            case 0 -> true;
            case 1 -> parent instanceof InscribableFigure;
            case 2, 3, 4 -> {
                if (parent instanceof TransitionFigure || parent instanceof PlaceFigure) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public boolean canBeParent(ParentFigure parent) {
        if (super.canBeParent(parent)) {
            return this.canBeParent(this.fType, parent);
        }
        return false;
    }

    public void release() {
        super.release();
        if (this.shadow != null) {
            this.shadow.discard();
        }
    }

    @Override
    public ShadowNetElement buildShadow(ShadowNet net) {
        ShadowInscribable parentShadow;
        this.shadow = null;
        if (this.fType != 0 && this.parent() instanceof ShadowHolder && (parentShadow = (ShadowInscribable)((ShadowHolder)this.parent()).getShadow()) != null) {
            if (this.fType == 1 || this.fType == 3) {
                this.shadow = new ShadowInscription(parentShadow, this.getText());
                this.shadow.context = this;
                this.shadow.setID(this.getID());
                this.shadow.setSpecial(this.fType == 3);
            } else if (this.fType == 2 && parentShadow instanceof ShadowNode) {
                ShadowNode shadowNode = (ShadowNode)parentShadow;
                shadowNode.setName(this.getText());
            } else if (this.fType == 4 && parentShadow instanceof ShadowNode) {
                ShadowNode shadowNode = (ShadowNode)parentShadow;
                shadowNode.setComment(this.getText());
            }
        }
        return this.shadow;
    }

    @Override
    public ShadowNetElement getShadow() {
        return this.shadow;
    }
}

