/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.IOHelper;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import de.renew.gui.CPNDrawing;
import de.renew.gui.LoadFileFromJarHelper;
import de.renew.util.ClassSource;
import de.renew.util.PathEntry;
import de.renew.util.StringUtil;
import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CPNDrawingLoader {
    private static final Logger logger = Logger.getLogger(CPNDrawingLoader.class);
    private PathEntry[] netSource;
    protected final Vector<CPNDrawing> drawings = new Vector();

    public CPNDrawingLoader() {
        this.configureNetPath(System.getProperties());
    }

    void configureNetPath(Properties props) {
        this.setNetPath(props.getProperty("de.renew.netPath", System.getProperty("user.dir")));
    }

    void setNetPath(String path) {
        this.setNetPath(StringUtil.splitPaths((String)path));
    }

    void setNetPath(String[] paths) {
        this.netSource = StringUtil.canonizePaths((String[])paths);
        if (logger.isDebugEnabled()) {
            for (PathEntry pathEntry : this.netSource) {
                logger.debug((Object)("Drawing loader source" + (pathEntry.isClasspathRelative ? " (relative to CLASSPATH): " : ": ") + pathEntry.path));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDrawing(CPNDrawing drawing) {
        Vector<CPNDrawing> vector = this.drawings;
        synchronized (vector) {
            this.drawings.addElement(drawing);
            logger.debug((Object)("CPNDrawingLoader: added " + drawing.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseDrawing(CPNDrawing drawing) {
        Vector<CPNDrawing> vector = this.drawings;
        synchronized (vector) {
            this.drawings.removeElement(drawing);
        }
        drawing.discardShadow();
        logger.debug((Object)("CPNDrawingLoader: released " + drawing.getName()));
    }

    public Iterator<CPNDrawing> loadedDrawings() {
        if (logger.isDebugEnabled()) {
            StringBuilder allNames = new StringBuilder();
            for (CPNDrawing drawing : this.drawings) {
                allNames.append(' ');
                allNames.append(drawing.getName());
            }
            logger.debug((Object)("CPNDrawingLoader: request for all drawings:" + String.valueOf(allNames)));
        }
        return this.drawings.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPNDrawing getDrawing(String name, boolean useLoader) {
        logger.debug((Object)("CPNDrawingLoader: request for " + name + " (loader " + (useLoader ? "en" : "dis") + "abled)"));
        if (name == null) {
            return null;
        }
        Vector<CPNDrawing> vector = this.drawings;
        synchronized (vector) {
            CPNDrawing loaded;
            for (int i = 0; i < this.drawings.size(); ++i) {
                CPNDrawing currentDrawing = this.drawings.elementAt(i);
                String currentName = currentDrawing.getName();
                if (!name.equals(currentName)) continue;
                return currentDrawing;
            }
            if (useLoader && (loaded = this.findDrawingFile(name)) != null) {
                return loaded;
            }
        }
        return null;
    }

    CPNDrawing getDrawing(String name) {
        return this.getDrawing(name, true);
    }

    public CPNDrawing findDrawing(String name, SimpleFileFilter type) {
        if (!this.drawingLoaded(name)) {
            for (PathEntry e : this.netSource) {
                File searchFile = new File(e.path + File.separator + name + "." + type.getExtension());
                if (!searchFile.canRead()) continue;
                StatusRememberer sr = new StatusRememberer();
                List newDrawings = DrawingFileHelper.loadDrawingList((File)searchFile, (StatusDisplayer)sr);
                for (Drawing d : newDrawings) {
                    if (!(d instanceof CPNDrawing)) continue;
                    CPNDrawing cpnDrawing = (CPNDrawing)d;
                    if (!name.equals(d.getName())) continue;
                    return cpnDrawing;
                }
            }
        }
        return null;
    }

    private boolean drawingLoaded(String name) {
        for (int i = 0; i < this.drawings.size(); ++i) {
            CPNDrawing currentDrawing = this.drawings.elementAt(i);
            String currentName = currentDrawing.getName();
            if (!name.equals(currentName)) continue;
            return true;
        }
        return false;
    }

    CPNDrawing findDrawingFile(String name) {
        CPNDrawing tmp = this.getDrawing(name, false);
        if (tmp != null) {
            return tmp;
        }
        File file = null;
        for (PathEntry pathEntry : this.netSource) {
            boolean error;
            URL url;
            block17: {
                url = null;
                StringBuilder buffer = new StringBuilder();
                buffer.append(pathEntry.path);
                if (!"".equals(pathEntry.path)) {
                    buffer.append(File.separator);
                }
                buffer.append(name);
                buffer.append(".rnw");
                String path = buffer.toString();
                logger.debug((Object)("looking for: " + path));
                try {
                    if (pathEntry.isClasspathRelative) {
                        url = ClassSource.getClassLoader().getResource(StringUtil.convertToSlashes((String)path));
                        error = url == null;
                        break block17;
                    }
                    file = new File(path);
                    boolean bl = error = !file.canRead();
                    if (!error) {
                        try {
                            url = file.toURI().toURL();
                        }
                        catch (MalformedURLException e) {
                            logger.error((Object)("Could not transform drawing filename to URL: " + e.getMessage()));
                            error = true;
                        }
                    }
                    if (error) {
                        file = null;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("CPN drawing loader: " + path + " caused " + String.valueOf(e)));
                    error = true;
                }
            }
            if (error) continue;
            assert (url != null) : "error should be set if url==null.";
            StatusRememberer statusRememberer = new StatusRememberer();
            Drawing newDrawing = file != null ? DrawingFileHelper.loadDrawing((File)file, (StatusDisplayer)statusRememberer) : DrawingFileHelper.loadDrawing((URL)url, (StatusDisplayer)statusRememberer);
            if (newDrawing == null || !(newDrawing instanceof CPNDrawing)) continue;
            IOHelper ioHelper = DrawPlugin.getCurrent().getIOHelper();
            if (ioHelper != null) {
                URL toOpen = url;
                if (SwingUtilities.isEventDispatchThread()) {
                    ioHelper.loadAndOpenDrawings(toOpen);
                } else {
                    try {
                        EventQueue.invokeAndWait(() -> ioHelper.loadAndOpenDrawings(toOpen));
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)"Caught interrupt while loading drawing", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        logger.error((Object)"Caught InvocationTargetException while loading drawing", (Throwable)e);
                    }
                }
            }
            return this.getDrawing(name, false);
        }
        LoadFileFromJarHelper.loadRnwFileFromJar(name);
        return this.getDrawing(name, false);
    }

    private static class StatusRememberer
    implements StatusDisplayer {
        private StatusRememberer() {
        }

        public void showStatus(String message) {
            logger.debug((Object)("CPNDrawingLoader: " + message));
        }
    }
}

