/*
 * Decompiled with CFR 0.152.
 */
package de.renew.splashscreen;

import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.load.ISplashscreenPlugin;
import de.renew.plugin.load.PluginLoaderComposition;
import de.renew.splashscreen.RenewSplashScreen;
import java.beans.PropertyChangeEvent;
import java.net.URL;

public class SplashscreenPlugin
extends PluginAdapter
implements ISplashscreenPlugin {
    private static final String KEY_SPLASHSCREEN_ENABLED = "de.renew.splashscreen.enabled";
    private RenewSplashScreen _renewSplashScreen;

    public SplashscreenPlugin(URL propertyURL) throws PluginException {
        super(propertyURL);
        this.showScreen();
    }

    public SplashscreenPlugin(PluginProperties props) {
        super(props);
        this.showScreen();
    }

    private void showScreen() {
        if (this.getProperties().getBoolProperty(KEY_SPLASHSCREEN_ENABLED)) {
            this._renewSplashScreen = RenewSplashScreen.getInstance();
            if (this._renewSplashScreen != null) {
                this._renewSplashScreen.showSplashScreen();
                PluginLoaderComposition.setSplashScreen((ISplashscreenPlugin)this);
            }
        } else {
            LOGGER.debug((Object)"Splash screen disabled by user choice.");
        }
    }

    public boolean cleanup() {
        if (this._renewSplashScreen != null) {
            this.closeSplashScreen();
        }
        PluginLoaderComposition.setSplashScreen(null);
        return super.cleanup();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this._renewSplashScreen.progressBarPropertyChange(evt);
    }

    public void closeSplashScreen() {
        this._renewSplashScreen.closeSplashScreen();
        this._renewSplashScreen = null;
    }
}

