/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.locate;

import de.renew.plugin.CollectionLister;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.locate.PluginFileFinder;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

public class PluginJarLocationFinder
extends PluginFileFinder {
    public static final Logger LOGGER = Logger.getLogger(PluginJarLocationFinder.class);

    public PluginJarLocationFinder(URL basedir) {
        super(basedir);
    }

    @Override
    protected File[] getPluginFiles(File dir) {
        return dir.listFiles(file -> {
            String name = file.getName();
            return file.isFile() && name.endsWith(".jar");
        });
    }

    @Override
    protected Collection<PluginProperties> getPluginConfigurations(File[] plugins) {
        Vector<PluginProperties> pluginURLv = new Vector<PluginProperties>();
        for (int i = 0; i < plugins.length; ++i) {
            PluginProperties cfg = this.createPluginConfig(plugins[i]);
            if (cfg == null) continue;
            pluginURLv.add(cfg);
        }
        return pluginURLv;
    }

    protected PluginProperties createPluginConfig(File loc) {
        if (!loc.exists()) {
            LOGGER.debug((Object)("jar file " + String.valueOf(loc) + " does not exist."));
            return null;
        }
        LOGGER.debug((Object)("looking for plugin.cfg in jar file " + String.valueOf(loc) + "..."));
        try {
            URL url = loc.toURI().toURL();
            PluginProperties props = null;
            JarFile jarFile = new JarFile(loc);
            ZipEntry entry = jarFile.getEntry("plugin.cfg");
            if (entry != null) {
                InputStream stream = jarFile.getInputStream(entry);
                props = new PluginProperties(url, stream);
                LOGGER.debug((Object)("zip entry " + String.valueOf(entry) + " found in " + jarFile.getName()));
            } else {
                LOGGER.debug((Object)("no zip entry found in " + jarFile.getName()));
            }
            return props;
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)("PluginJarLocationFinder: could not create URL from " + String.valueOf(loc)));
        }
        catch (Exception e) {
            LOGGER.error((Object)("PluginJarLocationFinder: " + String.valueOf(e)));
        }
        return null;
    }

    @Deprecated
    public static void main(String[] args) {
        PluginProperties.getUserProperties().setProperty("debug", "false");
        PluginJarLocationFinder finder = new PluginJarLocationFinder(null);
        Collection<PluginProperties> found = finder.findPluginLocations();
        System.out.println("found the following locations:");
        System.out.println(CollectionLister.toString(found));
    }
}

