/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.load;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginClassLoader;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.annotations.Provides;
import de.renew.plugin.di.FactoryDefinition;
import de.renew.plugin.di.ServiceContainer;
import de.renew.plugin.load.PluginInstantiationException;
import de.renew.plugin.load.PluginLoader;
import de.renew.plugin.load.SimplePluginLoader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public abstract class AbstractPluginLoader
implements PluginLoader {
    public static final Logger LOGGER = Logger.getLogger(SimplePluginLoader.class);
    protected final PluginClassLoader _loader;
    protected final ServiceContainer _container;

    public AbstractPluginLoader(PluginClassLoader loader, ServiceContainer container) {
        this._loader = loader;
        this._container = container;
    }

    public static URL[] unifyURL(URL url) {
        File dir = null;
        try {
            dir = new File(url.toURI());
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Unable to search for JAR files in " + String.valueOf(url) + ": " + String.valueOf(e)));
        }
        URL[] jarURLs = AbstractPluginLoader.getURLsFromDirectory(dir);
        if (jarURLs == null || jarURLs.length == 0) {
            LOGGER.warn((Object)("No JAR found in " + String.valueOf(url) + ", resorting to given URL."));
            return new URL[]{url};
        }
        return jarURLs;
    }

    private static URL[] getURLsFromDirectory(File location) {
        if (location == null) {
            return null;
        }
        if (location.getName().endsWith(".jar")) {
            try {
                Vector<URL> urls = new Vector<URL>();
                urls.add(location.toURI().toURL());
                String baseURL = "jar:" + String.valueOf(location.toURI().toURL()) + "!/";
                JarFile jar = new JarFile(location);
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    if (!entry.getName().startsWith("libs/") || !entry.getName().endsWith(".jar")) continue;
                    urls.add(new URL(baseURL + entry.getName()));
                }
                return urls.toArray(new URL[urls.size()]);
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)("SimplePluginLoader: Could not convert to URL: " + String.valueOf(location) + " (" + e.getMessage() + ")."));
            }
            catch (IOException e1) {
                LOGGER.error((Object)("Error while opening/reading jar file: " + String.valueOf(location)), (Throwable)e1);
            }
        }
        if (!location.isDirectory()) {
            location = location.getParentFile();
        }
        Vector<URL> result = AbstractPluginLoader.getJarsRecursiveFromDir(location);
        return result.toArray(new URL[result.size()]);
    }

    private static Vector<URL> getJarsRecursiveFromDir(File dir) {
        Vector<URL> v = new Vector<URL>();
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".jar");
            }
        });
        if (files == null) {
            return v;
        }
        for (File file : files) {
            if (file.isFile()) {
                try {
                    v.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    LOGGER.debug((Object)("Can't convert file location to URL: " + e.getMessage()), (Throwable)e);
                }
                continue;
            }
            if (!file.isDirectory()) continue;
            v.addAll(AbstractPluginLoader.getJarsRecursiveFromDir(file));
        }
        return v;
    }

    @Override
    public final IPlugin loadPlugin(PluginProperties props) {
        LOGGER.debug((Object)(this.getClass().getSimpleName() + " loading from " + String.valueOf(props.getURL())));
        try {
            Class<? extends IPlugin> mainClass = this.findMainClass(props);
            if (mainClass == null) {
                LOGGER.debug((Object)"* no main class!");
                return new PluginAdapter(props);
            }
            IPlugin plugin = this.createPlugin(props, mainClass);
            this.bindPluginServices(mainClass, plugin);
            return plugin;
        }
        catch (PluginInstantiationException e) {
            LOGGER.debug((Object)(this.getClass().getSimpleName() + ": " + e.getMessage()));
            if (LOGGER.isTraceEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public final IPlugin loadPluginFromURL(URL url) {
        PluginProperties props = new PluginProperties(url);
        try {
            InputStream stream = SimplePluginLoader.PluginConfigFinder.getConfigInputStream(url);
            props.load(stream);
            return this.loadPlugin(props);
        }
        catch (Exception e) {
            LOGGER.error((Object)("SimplePluginLoader.loadPluginFromURL: " + String.valueOf(e)));
            return null;
        }
    }

    protected abstract IPlugin createPlugin(PluginProperties var1, Class<? extends IPlugin> var2) throws PluginInstantiationException;

    protected Class<? extends IPlugin> findMainClass(PluginProperties props) {
        String className = props.getProperty("mainClass");
        if (className == null) {
            return null;
        }
        try {
            LOGGER.debug((Object)("* creating a " + className + " with cl " + String.valueOf(this._loader)));
            Class<?> mainClass = this._loader.loadClass(className);
            return mainClass.asSubclass(IPlugin.class);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)e.getMessage());
            return null;
        }
        catch (ClassCastException e) {
            LOGGER.error((Object)e.getMessage());
            return null;
        }
    }

    protected Collection<String> parseListString(String list) {
        StringTokenizer tok = new StringTokenizer(list, ",");
        Vector<String> result = new Vector<String>(tok.countTokens());
        try {
            while (tok.hasMoreTokens()) {
                String currentToken = tok.nextToken();
                result.add(currentToken);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.error((Object)("PluginLoader: " + String.valueOf(e) + " when parsing " + list + " as list!"));
        }
        return result;
    }

    private void bindPluginServices(Class<? extends IPlugin> mainClass, final IPlugin plugin) {
        this._container.set(mainClass, plugin);
        LOGGER.debug((Object)("Bound Service: " + String.valueOf(mainClass)));
        for (final Method method : plugin.getClass().getMethods()) {
            if (method.getAnnotation(Provides.class) == null) continue;
            Class<?> service = method.getReturnType();
            this._container.addDefinition(new FactoryDefinition<Object>(service, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return method.invoke((Object)plugin, new Object[0]);
                }
            }));
            LOGGER.debug((Object)("Bound Service: " + service.toString()));
        }
    }
}

