/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.jpms.impl;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

final class UnresolvedExports
implements Comparable<UnresolvedExports> {
    private final String _target;
    private final Set<String> _packages;
    private boolean _fromBoot;
    private WeakReference<ModuleLayer.Controller> _srcControl;

    private UnresolvedExports(String target) {
        this._target = target;
        this._packages = new HashSet<String>();
    }

    public static UnresolvedExports withTarget(String target) throws NullPointerException {
        return new UnresolvedExports(Objects.requireNonNull(target));
    }

    public UnresolvedExports from(ModuleLayer.Controller control) {
        if (this._srcControl == null || !this._srcControl.refersTo(control)) {
            this._packages.clear();
            this._srcControl = new WeakReference<ModuleLayer.Controller>(control);
        }
        this._fromBoot = false;
        return this;
    }

    UnresolvedExports fromBoot() {
        if (!this._fromBoot) {
            this._srcControl = new WeakReference<Object>(null);
            this._packages.clear();
            this._fromBoot = true;
        }
        return this;
    }

    public UnresolvedExports addPackages(Set<String> packages) {
        for (String pkg : packages) {
            if (pkg == null || pkg.isBlank()) continue;
            this._packages.add(pkg);
        }
        return this;
    }

    public void resolve(Module target) throws IllegalStateException {
        if (this._srcControl == null) {
            throw new IllegalStateException("No source specified for the packages.");
        }
        if (this._packages.isEmpty()) {
            return;
        }
        ModuleLayer.Controller control = (ModuleLayer.Controller)this._srcControl.get();
        if (control != null) {
            for (Module m : control.layer().modules()) {
                m.getPackages().stream().filter(this._packages::contains).forEach(pkg -> control.addExports(m, (String)pkg, target));
            }
        } else if (this._fromBoot) {
            Module loader = this.getClass().getModule();
            loader.getPackages().stream().filter(this._packages::contains).forEach(pkg -> loader.addExports((String)pkg, target));
        }
    }

    public String target() {
        return this._target;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnresolvedExports)) {
            return false;
        }
        UnresolvedExports other = (UnresolvedExports)o;
        return this.target().equals(other.target()) && this._packages.equals(other._packages);
    }

    public int hashCode() {
        return Objects.hash(this.target(), this._packages);
    }

    @Override
    public int compareTo(UnresolvedExports o) {
        if (o == this) {
            return 0;
        }
        int c = this.target().compareTo(o.target());
        if (c != 0) {
            return c;
        }
        Object[] a = this._packages.toArray(new String[0]);
        Object[] b = o._packages.toArray(new String[0]);
        Arrays.sort(a);
        Arrays.sort(b);
        return Arrays.compare((Comparable[])a, (Comparable[])b);
    }
}

