/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.jpms;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class ModuleLayerCreationException
extends RuntimeException {
    public ModuleLayerCreationException(Set<String> modulesToLoad, Collection<Module> loadedModules) {
        super("While loading the modules " + ModuleLayerCreationException.stringRepresentation(modulesToLoad) + ", the Java Module System attempted to include one or more different modules in the same layer. This is usually the result of an incorrect loading order of plugins. The following modules were included in this layer: " + ModuleLayerCreationException.stringRepresentation(loadedModules) + ". Please make sure that the additional modules are loaded before " + ModuleLayerCreationException.stringRepresentation(modulesToLoad) + ".");
    }

    public ModuleLayerCreationException(Set<String> modulesToLoad, Collection<String> requiredLayers, Collection<ModuleLayer> foundLayers) {
        super("Couldn't find all of the required parent layers for modules " + ModuleLayerCreationException.stringRepresentation(modulesToLoad) + ". Required parent layers: " + ModuleLayerCreationException.stringRepresentation(requiredLayers) + ". Found layers: " + ModuleLayerCreationException.stringRepresentation(foundLayers) + ". This is usually the result of an incorrect loading order of plugins. Please make sure that all required modules are loaded before " + ModuleLayerCreationException.stringRepresentation(modulesToLoad) + ".");
    }

    private static String stringRepresentation(Collection<?> items) {
        return items.stream().map(ModuleLayerCreationException::stringRepresentation).collect(Collectors.joining(", "));
    }

    private static String stringRepresentation(Object item) {
        if (item instanceof Module) {
            Module m = (Module)item;
            return m.getName();
        }
        return item.toString();
    }
}

