/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.jpms;

import de.renew.plugin.jpms.ComponentLayer;
import de.renew.plugin.jpms.ComponentLayerFactory;
import de.renew.plugin.jpms.ModuleConfigurationException;
import de.renew.plugin.jpms.ModuleLayerCreationException;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class AbstractLayerFactory
implements ComponentLayerFactory,
ComponentLayerFactory.Facilitator {
    private static final String ROOT = "de.renew.loader";

    @Override
    public final Optional<ComponentLayer> create(String name, Set<Path> toLoad, Set<Path> dependencyLocations, List<ComponentLayer> loaded, ClassLoader parentCL) {
        Set<ModuleLayer> layers;
        ModuleLayer.Controller ctrl;
        Objects.requireNonNull(parentCL);
        Set<ModuleReference> modules = AbstractLayerFactory.getModuleReferencesFrom(toLoad);
        Set<String> moduleNames = AbstractLayerFactory.getModuleNames(modules);
        Set<String> requires = this.determineParentLayers(modules);
        ModuleFinder finder = this.createModuleFinder(toLoad, dependencyLocations);
        if (requires.isEmpty()) {
            requires.add(ROOT);
        }
        if (!this.verify((ctrl = AbstractLayerFactory.createLayer(moduleNames, layers = loaded.stream().map(ComponentLayer::getLayer).collect(Collectors.toSet()), requires, parentCL, finder)).layer(), moduleNames)) {
            throw new ModuleLayerCreationException(moduleNames, ctrl.layer().modules());
        }
        List<ComponentLayer> parents = AbstractLayerFactory.getParentComponents(ctrl.layer(), loaded);
        return Optional.ofNullable(this.createComponentLayer(name, ctrl, parents));
    }

    protected Set<String> determineParentLayers(Set<ModuleReference> modules) {
        Set<ModuleDescriptor.Requires> requiredModules = AbstractLayerFactory.getAllDependencies(modules);
        return AbstractLayerFactory.getRequiredModuleNames(requiredModules);
    }

    @Override
    public ModuleFinder createModuleFinder(Set<Path> modulesToLoad, Set<Path> dependencyLocations) {
        HashSet<Path> searchPaths = new HashSet<Path>(modulesToLoad);
        if (dependencyLocations != null) {
            searchPaths.addAll(dependencyLocations);
        }
        return ModuleFinder.of((Path[])searchPaths.toArray(Path[]::new));
    }

    protected boolean verify(ModuleLayer layer, Set<String> modulesToLoad) {
        return layer.modules().size() == modulesToLoad.size();
    }

    private static ModuleLayer.Controller createLayer(Set<String> toLoad, Set<ModuleLayer> loaded, Set<String> parentNames, ClassLoader parentCL, ModuleFinder finder) {
        LinkedHashSet<ModuleLayer> parentLayers = new LinkedHashSet<ModuleLayer>();
        LinkedHashSet<Configuration> parentConfigurations = new LinkedHashSet<Configuration>();
        for (ModuleLayer loadedLayer : loaded) {
            for (String parentLayerName : parentNames) {
                List<String> modulesInLoadedLayer = AbstractLayerFactory.getModuleNamesInLayer(loadedLayer);
                if (!modulesInLoadedLayer.contains(parentLayerName) || parentLayers.contains(loadedLayer)) continue;
                parentLayers.add(loadedLayer);
                parentConfigurations.add(loadedLayer.configuration());
            }
        }
        if (parentConfigurations.isEmpty()) {
            throw new ModuleLayerCreationException(toLoad, parentNames, parentLayers);
        }
        Configuration newConfiguration = Configuration.resolve(ModuleFinder.of(new Path[0]), new ArrayList<Configuration>(parentConfigurations), finder, toLoad);
        ModuleLayer.Controller control = ModuleLayer.defineModulesWithOneLoader(newConfiguration, new ArrayList<ModuleLayer>(parentLayers), parentCL);
        ModuleLayer newLayer = control.layer();
        boolean rerun = false;
        for (Module m : newLayer.modules()) {
            String name = m.getName();
            for (ModuleLayer l : loaded) {
                if (!l.modules().stream().map(Module::getName).anyMatch(module -> module.equals(name))) continue;
                parentLayers.add(l);
                parentConfigurations.add(l.configuration());
                rerun = true;
            }
        }
        if (rerun) {
            newConfiguration = Configuration.resolve(ModuleFinder.of(new Path[0]), new ArrayList<Configuration>(parentConfigurations), finder, toLoad);
            control = ModuleLayer.defineModulesWithOneLoader(newConfiguration, new ArrayList<ModuleLayer>(parentLayers), parentCL);
        }
        return control;
    }

    private static List<ComponentLayer> getParentComponents(ModuleLayer layer, List<ComponentLayer> from) {
        return from.stream().filter(c -> layer.parents().contains(c.getLayer())).collect(Collectors.toList());
    }

    private static Set<ModuleReference> getModuleReferencesFrom(Set<Path> paths) {
        return paths.stream().map(AbstractLayerFactory::getModuleReferenceFromPath).collect(Collectors.toUnmodifiableSet());
    }

    private static ModuleReference getModuleReferenceFromPath(Path moduleJarPath) {
        ModuleFinder jarModuleFinder = ModuleFinder.of(moduleJarPath);
        Set<ModuleReference> referencedModulesInJar = jarModuleFinder.findAll();
        if (referencedModulesInJar.size() != 1) {
            throw new ModuleConfigurationException("A modular jar must contain exactly one module!");
        }
        return (ModuleReference)referencedModulesInJar.stream().findFirst().get();
    }

    private static Set<ModuleDescriptor.Requires> getAllDependencies(Set<ModuleReference> modules) {
        Set<String> moduleNames = AbstractLayerFactory.getModuleNames(modules);
        return modules.parallelStream().map(ModuleReference::descriptor).map(ModuleDescriptor::requires).flatMap(Collection::stream).filter(r -> !moduleNames.contains(r.name())).collect(Collectors.toUnmodifiableSet());
    }

    private static Set<String> getModuleNames(Set<ModuleReference> modules) {
        return modules.stream().map(ModuleReference::descriptor).map(ModuleDescriptor::name).collect(Collectors.toUnmodifiableSet());
    }

    private static Set<String> getRequiredModuleNames(Set<ModuleDescriptor.Requires> requires) {
        HashSet<String> requiredModuleNames = new HashSet<String>();
        for (ModuleDescriptor.Requires require : requires) {
            String requireString = require.name();
            boolean isStatic = require.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC);
            Supplier<Boolean> isInBoot = () -> ModuleLayer.boot().findModule(requireString).isPresent();
            if (isStatic || isInBoot.get().booleanValue()) continue;
            requiredModuleNames.add(requireString);
        }
        return requiredModuleNames;
    }

    private static List<String> getModuleNamesInLayer(ModuleLayer layer) {
        return layer.modules().stream().map(Module::getName).collect(Collectors.toList());
    }
}

