/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.di;

import de.renew.plugin.annotations.Provides;
import de.renew.plugin.di.Definition;
import de.renew.plugin.di.MissingDependencyException;
import de.renew.plugin.di.ServiceContainer;
import de.renew.plugin.di.SingletonDefinition;
import java.lang.reflect.Method;
import java.util.HashMap;

public class Container
implements ServiceContainer {
    private final HashMap<Class<?>, Definition<?>> _definitions = new HashMap();

    @Override
    public boolean has(Class<?> service) {
        return this._definitions.containsKey(service);
    }

    @Override
    public Object get(Class<?> service) throws MissingDependencyException {
        if (!this.has(service)) {
            throw new MissingDependencyException(service);
        }
        return this._definitions.get(service).create();
    }

    @Override
    public <T> void set(Class<?> service, T singleton) {
        this.addDefinition(new SingletonDefinition<T>(service, singleton));
    }

    @Override
    public void addDefinition(Definition<?> definition) {
        this._definitions.put(definition.getService(), definition);
    }

    @Override
    public void unbind(Class<?> service) {
        if (!this.has(service)) {
            throw new IllegalArgumentException("Service " + String.valueOf(service) + " is not bound to this service container.");
        }
        this._definitions.remove(service);
        this.unbindAssociatedServices(service);
    }

    private void unbindAssociatedServices(Class<?> service) {
        for (Method method : service.getMethods()) {
            if (!method.isAnnotationPresent(Provides.class)) continue;
            this._definitions.remove(method.getReturnType());
        }
    }
}

