/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.command;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.InteractiveCLCommand;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class LoadCommand
implements InteractiveCLCommand {
    public static final Logger LOGGER = Logger.getLogger(LoadCommand.class);

    @Override
    public void execute(String[] args, PrintStream response) {
        this.execute(args, response, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(String[] args, PrintStream response, InteractiveCLCommand.InputSupplier additionalInputSupplier) {
        URL url;
        block19: {
            if (args.length != 1 || LoadCommand.isHelpArgument(args[0])) {
                LoadCommand.printUsage(response);
                return;
            }
            url = null;
            File parameterFile = null;
            String parameter = args[0];
            response.println("\n\n------- LOAD -------\n\n");
            if (!parameter.contains("*")) {
                try {
                    URL tmpURL = new URL(parameter);
                    parameterFile = LoadCommand.getFile(tmpURL);
                    if (parameterFile == null) {
                        url = tmpURL;
                    }
                }
                catch (MalformedURLException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(LoadCommand.class.getSimpleName() + ": Ignoring exception: " + String.valueOf(e)));
                    }
                    parameterFile = new File(parameter);
                }
            }
            if (url != null) {
                if (LoadCommand.isLoaded(url, response)) {
                    url = null;
                }
            } else {
                try {
                    if (parameterFile != null && parameterFile.isAbsolute() && parameterFile.exists()) {
                        if (LoadCommand.isLoaded(parameterFile, response)) break block19;
                        url = LoadCommand.createURL(parameterFile);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)(LoadCommand.class.getSimpleName() + ": directly found URL: " + String.valueOf(url)));
                        }
                        break block19;
                    }
                    List<File> pluginLocations = LoadCommand.getPluginLocations();
                    List<File> matches = LoadCommand.getMatchingPlugins(pluginLocations, parameterFile, parameter);
                    if (matches.size() > 1) {
                        LoadCommand.printMatches(response, matches, parameter);
                        if (additionalInputSupplier == null) {
                            response.println("Multiple matches found for " + parameter + ". Could not load plugin.");
                            return;
                        }
                        int choice = LoadCommand.selectFile(response, matches, parameter, additionalInputSupplier);
                        if (choice < 0) return;
                        url = LoadCommand.createURL(matches.get(choice));
                        break block19;
                    }
                    if (matches.size() == 1) {
                        File file = matches.get(0);
                        if (!LoadCommand.isLoaded(file, response)) {
                            url = LoadCommand.createURL(file);
                        }
                        break block19;
                    }
                    response.println("No match found for " + parameter + ".");
                }
                catch (Exception e) {
                    response.println("load failed: " + String.valueOf(e));
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    url = null;
                }
            }
        }
        if (url == null) {
            response.println("Stop command 'load " + args[0] + "'.");
            return;
        }
        LOGGER.debug((Object)(LoadCommand.class.getSimpleName() + ": Trying to load plugin from URL: " + String.valueOf(url)));
        IPlugin plugin = PluginManager.getInstance().loadPlugin(url);
        if (plugin != null) {
            response.println("\nPlug-in: \t" + plugin.getName() + "\t successfully loaded.\n");
            return;
        }
        response.println("Plug-in (" + String.valueOf(url) + ") not loaded. See log messages for details.");
    }

    private static boolean isHelpArgument(String arg) {
        return Arrays.asList("h", "-h", "--help", "--h", "-help").contains(arg);
    }

    private static void printUsage(PrintStream response) {
        response.println("usage: load <url>\nexamples: \nload file:/path/to/location/name/plugin.cfg\nload file:/path/to/location/pluginname.jar\nload pluginname.jar\nload pluginname*\nload *pluginname*");
    }

    private static List<File> getPluginLocations() throws IOException, URISyntaxException {
        File loaderLocation;
        String pluginLocationProp = PluginProperties.getUserProperties().getProperty("pluginLocations");
        ArrayList<File> pluginLocations = new ArrayList<File>();
        if (pluginLocationProp != null) {
            String[] pluginLocationNames;
            for (String string : pluginLocationNames = pluginLocationProp.split(File.pathSeparator)) {
                pluginLocations.add(new File(string).getCanonicalFile());
            }
        }
        if (!pluginLocations.contains(loaderLocation = new File(new File(PluginManager.getLoaderLocation().toURI()), "plugins").getCanonicalFile())) {
            pluginLocations.add(loaderLocation);
        }
        return pluginLocations;
    }

    private static List<File> getMatchingPlugins(List<File> pluginLocations, File parameterFile, String parameter) {
        ArrayList<File> matches = new ArrayList<File>();
        for (File pluginLocation : pluginLocations) {
            LOGGER.debug((Object)(LoadCommand.class.getSimpleName() + ": Plugin Location found: " + pluginLocation.getAbsolutePath()));
            if (!pluginLocation.exists()) continue;
            if (parameterFile != null) {
                File file = new File(pluginLocation, parameterFile.getPath());
                if (!file.exists()) continue;
                matches.add(file);
                continue;
            }
            File[] files = pluginLocation.listFiles();
            if (files == null) continue;
            for (File file : files) {
                String filenameLower = file.getName().toLowerCase();
                String parameterLower = parameter.toLowerCase();
                Object pattern = Arrays.stream(parameterLower.split("\\*")).map(Pattern::quote).collect(Collectors.joining(".*"));
                if (parameterLower.endsWith("*")) {
                    pattern = (String)pattern + ".*";
                }
                if (!filenameLower.matches((String)pattern)) continue;
                LOGGER.debug((Object)(LoadCommand.class.getSimpleName() + ": Adding to matched plugin list: " + file.getAbsolutePath()));
                if (file.isDirectory()) {
                    File pluginFile = new File(file, "plugin.cfg");
                    if (!pluginFile.exists() || matches.contains(pluginFile)) continue;
                    matches.add(pluginFile);
                    continue;
                }
                if (matches.contains(file)) continue;
                matches.add(file);
            }
        }
        return matches;
    }

    private static URL createURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    private static File getFile(URL url) {
        if ("file".equals(url.getProtocol())) {
            return new File(url.getFile());
        }
        return null;
    }

    private static int selectFile(PrintStream out, List<File> matches, String prompt, InteractiveCLCommand.InputSupplier additionalInputSupplier) {
        String selection;
        out.print("Press enter to stop loading plug-in, or type selection number: ");
        String stop = "Stop  command 'load " + prompt + "'.";
        try {
            selection = additionalInputSupplier.get();
        }
        catch (IOException e) {
            out.println("Could not load selected plug-in due to exception : " + String.valueOf(e) + ".");
            out.println(stop);
            return -1;
        }
        if (selection != null && !selection.trim().isEmpty()) {
            selection = selection.trim();
            try {
                int choice = Integer.parseInt(selection) - 1;
                if (choice < 0 || choice >= matches.size()) {
                    out.println("Selection " + selection + " not known.");
                    out.println(stop);
                    return -1;
                }
                File file = matches.get(choice);
                if (file == null) {
                    out.println("Selection " + choice + " not known");
                    out.println(stop);
                    return -1;
                }
                if (LoadCommand.isLoaded(file, out)) {
                    out.println(stop);
                    return -1;
                }
                return choice;
            }
            catch (Exception e) {
                out.println("Selection " + selection + " not known.");
                out.println(stop);
                return -1;
            }
        }
        out.println("No selection made.");
        out.println(stop);
        return -1;
    }

    private static void printMatches(PrintStream out, List<File> matches, String prompt) {
        int maxLength = LoadCommand.calculateMaxLength(matches);
        String columnGap = " ".repeat(3);
        out.println("The following plug-ins were found for " + prompt + " : \n");
        String title = " Selection" + columnGap + String.format("%-" + maxLength + "s", "Path") + columnGap + "Status ";
        out.println(title);
        out.println("-".repeat(title.length()));
        for (int i = 0; i < matches.size(); ++i) {
            File file = matches.get(i);
            String absolutePath = file.getAbsolutePath();
            String numberFormat = String.format("%9d", i + 1);
            String status = LoadCommand.isLoaded(file) ? "loaded" : "  --";
            out.println(" " + numberFormat + columnGap + String.format("%-" + maxLength + "s", absolutePath) + columnGap + status);
        }
        out.println();
    }

    private static int calculateMaxLength(List<File> files) {
        return files.stream().map(File::getAbsolutePath).mapToInt(String::length).max().orElse(0);
    }

    private static boolean isLoaded(Object address) {
        return LoadCommand.getPlugin(address) != null;
    }

    private static boolean isLoaded(Object address, PrintStream ps) {
        String addressName;
        IPlugin plugin = LoadCommand.getPlugin(address);
        if (address instanceof File) {
            File file = (File)address;
            addressName = file.getName();
            if ("plugin.cfg".equals(addressName)) {
                addressName = file.getParentFile().getName();
            }
        } else {
            addressName = address.toString();
        }
        if (plugin != null) {
            ps.println("\n\tPlug-in \t" + plugin.getName() + " [" + addressName + "]\t already loaded.\n");
            return true;
        }
        return false;
    }

    private static IPlugin getPlugin(Object address) {
        if (address instanceof File) {
            return LoadCommand.getPlugin((File)address);
        }
        if (address instanceof URL) {
            return LoadCommand.getPlugin((URL)address);
        }
        throw new IllegalArgumentException(String.valueOf(address) + " is neither a " + File.class.getSimpleName() + " nor a " + URL.class.getSimpleName() + " instance.");
    }

    private static IPlugin getPlugin(File file) {
        block5: {
            try {
                File cf = file.getCanonicalFile();
                for (IPlugin plugin : PluginManager.getInstance().getPlugins()) {
                    try {
                        File cpf;
                        File pf = LoadCommand.getFile(plugin.getProperties().getURL());
                        if (pf == null || !cf.equals(cpf = pf.getCanonicalFile()) && (!cf.equals(cpf.getParentFile()) || !cpf.isFile()) && (!cpf.equals(cf.getParentFile()) || !cf.isFile())) continue;
                        return plugin;
                    }
                    catch (IOException e) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug((Object)(LoadCommand.class.getSimpleName() + ": Ignoring exception while comparing the given file with " + plugin.getProperties().getURL().getFile() + ": " + String.valueOf(e)));
                    }
                }
            }
            catch (IOException e) {
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug((Object)(LoadCommand.class.getSimpleName() + ": Aborting the comparison of " + String.valueOf(file) + " with the plug-in URLs because of: " + String.valueOf(e)));
            }
        }
        return null;
    }

    private static IPlugin getPlugin(URL url) {
        for (IPlugin plugin : PluginManager.getInstance().getPlugins()) {
            if (!url.sameFile(plugin.getProperties().getURL())) continue;
            return plugin;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "Load a new plug-in. Type 'load -help' to get examples of usage.";
    }

    @Override
    public String getArguments() {
        return "locationNames";
    }
}

